(defun max-depth (expr)
  "Max-Depth calculates the maximum nesting depth of an expression."
  (cond ((null expr) 0)
	((atom expr) 0)
	(t (max (+ 1 (max-depth (car expr)))
		(max-depth (cdr expr))))))

(defun count-atoms (expr)
  "Max-Depth calculates the maximum nesting depth of an expression."
  (cond ((null expr) 0)
	((atom expr) 1)
	(t (max (+ 1 (count-atoms (car expr)))
		(count-atoms (cdr expr))))))

(defconstant positive-quadratic-expression
	     '(/ (+ (- b) (sqrt (- (expt b 2) (* 4 a c)))) (* 2 a)))

