;;; George A. Madrid
;;; Problem Set 3
;;; CarlManning, Thursday 10-11

;;; Part 1.1
(defclass container ()
  ((filled-to :accessor filled-to 
	      :initform 0)))

;;; Part 1.2
(defclass box (container)
  ((height :accessor height)
   (width :accessor width)
   (extent :accessor extent)))

(defclass cylinder (container)
  ((radius :accessor radius)
   (extent :accessor extent)))

;;; Part 1.3
(defclass railroad-car ()
  ((number :accessor number
	   :initform 'xxxx)))

;;; Part 1.4
(defclass engine (railroad-car) ())
(defclass caboose (railroad-car) ())
(defclass box-car (railroad-car box)
  ((height :initform 9)
   (width :initform 7)
   (extent :initform 40)))
(defclass tank-car (railroad-car cylinder)
  ((radius :initform 3.5)
   (extent :initform 35)))
(defclass gondola-car (box-car)
  ((height :initform 5)))

;;; Part 1.5
(defclass fridge (container) ())
(defclass refrigerator-car (box-car fridge) ())


;;; Part 2.1
(defmethod volume ((b box))
  (* (* (height b) (width b))
     (extent b)))
(defmethod volume ((c cylinder))
  (* pi (expt (radius c) 2)))

;;; Part 2.2
(defmethod containable-volume (thing)
  (volume thing))
(defmethod containable-volume ((thing railroad-car))
  0)
(defmethod containable-volume ((thing tank-car))
  (volume thing))
(defmethod containable-volume ((thing box-car))
  (/ (* 9 (volume thing)) 10))
(defmethod containable-volume ((thing gondola-car))
  (/ (* 11 (volume thing)) 10))

;;; Part 2.3
(defmethod volume-contained (thing)
  0)
(defmethod volume-contained ((thing container))
  (* 0.01 (filled-to thing) (containable-volume thing)))


;;; Part 3.1
(defmethod read-car :before ((x railroad-car) stream)
  (setf (number x) (read stream)))

;;; Part 3.2
(defmethod read-car :after ((x box-car) stream)
  (setf (filled-to x) (read stream)))
(defmethod read-car :after ((x tank-car) stream)
  (setf (filled-to x) (read stream)))

;;; Part 3.3
(defmethod read-car ((x box-car) stream)
  (setf (extent x) (read stream)))
(defmethod read-car ((x tank-car) stream)
  (setf (extent x) (read stream)))

;;; Part 3.4 
(defmethod read-car ((x refrigerator-car) stream)
  x)

;;; Part 3.5
> (read-train "/mit/6.034/ps3/train.dta")

E-01	0
G-59	1694
G-53	346
T-09	28
G-28	2002
R-73	2268
B-49	3402
T-60	19
G-97	1694
B-45	0
R-37	2268
G-05	423
T-36	28
R-12	0
B-94	1701
B-52	1701
T-64	32
R-36	0
G-25	423
B-22	3402
T-10	28
R-64	0
B-03	3402
B-18	0
B-23	1701
B-92	0
G-06	1694
G-34	0
G-62	1636
R-13	2268
T-09	28
T-35	28
T-63	30
T-37	36
C-38	0
The train's total volume carrying cargo is 32290 cubic feet.
> =->
