/*
 * nsobj.h - Description of the nsObj type, the basic NS Object.
 *
 * Copyright (C) 1997, George Madrid
 * All rights reserved.
 */

#ifndef INC_NSOBJ_H
#define INC_NSOBJ_H

/* ---------------- Public stuff ---------------- */
typedef int32 nsObj;

int ns_initialize(void);
int nso_initialize(void);
int init_symbol_tree(void);

/* Class operations */
int nso_primclass(nsObj);
nsObj nso_classof(nsObj);
int nso_isarray(nsObj);
int nso_isframe(nsObj);
int nso_isbinary(nsObj);
int nso_isinteger(nsObj);
int nso_isboolean(nsObj);
int nso_ischaracter(nsObj);
int nso_issymbol(nsObj);
int nso_isreal(nsObj);
int nso_isstring(nsObj);
int symbol_equal(nsObj, nsObj);	/* A crock until symbols really work -gam */
void nso_print(nsObj);

/* Constructors */
nsObj make_integer(int32);
nsObj make_boolean(int32);
nsObj make_character(int32);
nsObj make_binary(size_t, nsObj);
nsObj make_symbol_symbol(void);	/* Only for use by the initializer */
nsObj make_string_symbol(void);	/* Only for use by the initializer */
nsObj make_symbol(const char *);
nsObj make_string(const char *);
nsObj make_array(int16, nsObj);

/* Modifiers */
nsObj nso_setARef(nsObj, nsObj, nsObj);
nsObj nso_AddArraySlot(nsObj, nsObj);

/* Observers */
nsObj nso_ARef(nsObj, nsObj);

/* ----- Primitive class tags - type information for reference types ----- */ 
/* I'm starting these at 4 so that there's no conflict with the tags. */
/* Paranoia */
#define PRIMC_BINARY    0x04
#define PRIMC_ARRAY     0x05
#define PRIMC_FRAME     0x06
#define PRIMC_IMMEDIATE 0x07

/* ---------- Type constants ---------- */
/* The first two (or three) bits of every nsObj give its type */
#define IMMED_BITS     0x00  /*   0 */
#define INTEGER_BITS   0x00  /*  00 */
#define BOOLEAN_BITS   0x02  /* 010 */
#define CHARACTER_BITS 0x06  /* 110 */
#define ALLREFS_BITS   0x01  /*   1 */
#define REFERENCE_BITS 0x01  /*  01 */
#define MAGICPTR_BITS  0x03  /*  11 */

/* Hey, look, true and nil are immediates, so we can make them macros */
#define NS_NIL  0x00000002
#define NS_TRUE 0x0000001A

/* ----- Some stupid macros ----- */
#define ref_index(ref) ((ref) >> 2)

/* ----- Type access macros ----- */
#define int_value(nso)  ((nso) >> 2)

nsObj SYMBOL_CLASS;
nsObj STRING_CLASS;
nsObj FRAME_CLASS;
nsObj ARRAY_CLASS;

#endif /* INC_NSOBJ_H */
