/*
 * utils.c - Some misc. utility functions
 *
 * Copyright (C) 1997, George Madrid
 * All rights reserved.
 */

#include <stdio.h>

#include "config.h"
#include "utils.h"
#include "ctype.h"

int
strcasecmp(const char *s1, const char *s2)
{
     register del;
     while (*s1 || *s2) {
	  if ((del = (tolower(*s1++) - tolower(*s2++)))) return del;
     }
     return(0);
}

int
ustrcasecmp(const int16 *s1, const int16 *s2)
{
     register del;
     while (*s1 || *s2) {
	  if ((del = (utolower(*s1++) - utolower(*s2++)))) return del;
     }
     return(0);
}

int
utolower(int16 uchar)
{
     /* This isn't even close to correct */
     if (uchar > 128) return uchar;
     return tolower(uchar);
}

void
copy_cstr_to_ustr(int16 *dst, const char *src)
{
     /* There is NO bounds checking done here.  Just copy those bytes. */
     do {
     } while ((*dst++ = *src++));
}

void
print_ustr(const int16 *ustr)
{
     while (*ustr) {
	  fputc((char)*ustr++, stdout);
     }
}

void
output_two_char_hex(const char num)
{
     static char *hex_lookup = "0123456789abcdef";

     fputc(hex_lookup[num >> 4], stdout);
     fputc(hex_lookup[num & 0x0f], stdout);
}

