/*
 * cpile.c -- A stack of cards where only the top card can be seen.
 */

/*
 * NOTE:  This initial implementation is just for freecell, because it only
 * allows cards to be added, not removed.  This means that only the top card
 * is remembered, and all other cards are destroyed.
 */

#include <stdlib.h>

#include "fc.h"
#include "err.h"

#include "area.h"
#include "card.h"
#include "cpile.h"

/* ---------------------------------------------------------------------- */
struct cpile *
cpile_create()
{
     struct cpile *ret;

     ret = calloc(sizeof(*ret), 1);
     return(ret);
}

/* ---------------------------------------------------------------------- */
void
cpile_destroy(struct cpile *clp)
{
     if (clp->topcard) card_destroy(clp->topcard);
     free(clp);
}

/* ---------------------------------------------------------------------- */
int
cpile_makeempty(struct cpile *clp)
{
     if (clp->topcard) card_destroy(clp->topcard);
     clp->topcard = NULL;
     if (clp->ap) area_clear(clp->ap);
     return(0);
}

/* ---------------------------------------------------------------------- */
int
cpile_addcard(struct cpile *clp, struct card *cdp)
{
     if (clp->topcard) card_destroy(clp->topcard);
     clp->topcard = cdp;
     
     if (clp->ap) {
	  area_clear(clp->ap);
     }

     return(0);
}

/* ---------------------------------------------------------------------- */
struct card *
cpile_getcard(struct cpile *clp)
{
     return(clp->topcard);
}

/* ---------------------------------------------------------------------- */
void
cpile_draw(struct cpile *clp, struct wind *windp, int x, int y)
{
     card_draw(clp->topcard, windp, x, y);
}
