/*
 * fc.h - Freecell
 */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include "wind.h"

/* ---------- Macros ---------- */
#define TRUE  1
#define FALSE 0

#define min(a,b)  (((a) < (b)) ? (a) : (b))
#define max(a,b)  (((a) > (b)) ? (b) : (a))

/* Stuff for gfx.c */
#define	NUM_RANKS	13
#define	NUM_SUITS	4

#define INIT_X 0
#define INIT_Y 0
#define INIT_WIDTH  ((CARD_WIDTH + CARD_SPACE) * 8 + (CARD_SPACE))
#define INIT_HEIGHT ((CARD_HEIGHT + CARD_SPACE) * 2 + (CARD_SPACE * 2) + 250)

/* ---------- Data structures ---------- */
struct world {
     struct wind *window;
};

/* ---------- Global variables ---------- */
extern Display *dpy;
extern XTextProperty gameTextProp;
extern XTextProperty gameIconProp;
extern char gameName[100];
extern int done;
extern struct world gworld;
extern int is_color;
extern int round_cards;

/* ---------- Arg stuff ---------- */
extern char *win_back_color;

/* ---------- Function declarations ---------- */
void do_event(XAnyEvent *);

/* pcard.c */
void make_card_maps(void);
void gfx_init(Display *, int, Window);

/* wintools.c */
void clear_rect(Display *, struct wind *, XRectangle *, int);
int rect_in_rgn(XRectangle *, Region);

/* ---------- Portability hacks ---------- */
#define NO_RANDOM
#ifdef NO_RANDOM
#   define random() rand()
#   define srandom(a) srand(a)
#endif
