/*
 * wind.h - Header for the wind data type.
 */

/* ---------- Macros ---------- */
#define FREE_WINDOW 0
#define FC_WINDOW 1

/* ---------- Data structures ---------- */
struct wind;
struct wind_ops {
     void (*open)(struct wind *);
     void (*term)(struct wind *);
     void (*mouse)(struct wind *, XButtonEvent *);
     void (*draw)(struct wind *, Region);
     void (*resize)(struct wind *, XConfigureEvent *);
     void (*key)(struct wind *, XKeyEvent *);
     void (*activate)(struct wind *, XMapEvent *);
     void (*deactivate)(struct wind *, XUnmapEvent *);
};

struct fcw {
     struct game *gp;
     struct area *csapp[8];
     struct area *clapp[4];
     struct area *cdapp[4];
     struct area *floaterp;
};

struct wind {
     int type;
     XRectangle bounds;
     struct wind *parent;
     GC gc;
     GC invertgc;
     Window window;
     struct area **areas;
     int num_areas;
     int max_areas;
     struct wind_ops *ops;
     union {
	  struct fcw fcw;
     } onion;
};

struct wind_params {
     int win_type;
     int x;
     int y;
     int width;
     int height;
     GC gc;
     struct wind *parent;
     unsigned long bck_color;
};

/* ---------- Function declarations ---------- */
/*
 * wind_create(parent, wop) -> struct wind *
 * 
 * Create a window which is a child of parent (parent can be NULL), and
 * which has parameters described in wop.
 */
struct wind *wind_create(struct wind *, struct wind_params *);

/*
 * wind_syswin(wind) -> system_window_type
 * 
 * Return the system identifier for the window.
 */
#define wind_syswin(w)  ((w)->window)

/*
 * wind_destroy(wind)
 * 
 * Destroy the window and free up its stuff.
 */
void wind_destroy(struct wind *);

/* ---------- Method functions ---------- */
void wind_key(struct wind *, XKeyEvent *);
void wind_mouse(struct wind *, XButtonEvent *);
void wind_draw(struct wind *, XExposeEvent *);
void wind_resize(struct wind *, XConfigureEvent *);
void wind_activate(struct wind *, XMapEvent *);
void wind_deactivate(struct wind *, XUnmapEvent *);

/* ---------- Subclass "Open" functions ---------- */
void fcwind_open(struct wind *);
