/*
 * expose.h
 */

/*
 * handle_expose(
 *
 * Handle the expose event by building up a clip region which will later be
 * redrawn upon callind do_cached_expose().  NOTE: if this expose event is for
 * a different window than the previously cached events, do_cached_expose()
 * will automatically be called.
 */
void handle_expose();

/*
 * do_cached_expose(
 *
 * Actually call the window draw events which have been cached.  Pass them the
 * accumulated region.
 */
void do_cached_expose();

/*
 * flush_expose(
 *
 * Run through the events in the event queue and extract and handle all expose
 * events.  Leave the other events in the queue.
 */
void flush_expose();

/*
 * flush_expose_window(
 *
 * Run through the events in the event queue and extract and handle all expose
 * events for the specified window.
 */
void flush_expose_window();

/*
 * flush_cache(
 *
 * Destroy the cached region without calling expose routines.
 */
void flush_cache();

/*
 * set_find_window_func(func)
 *
 * Set the function which is used to find the window to which an event
 * belongs.
 */
void set_find_window_func(struct wind *(*)(XExposeEvent *));

