/* gdbpanel.c:  Simple program to turn debugging on and off
 *
 * (c) 1996, 1997 D. Jeff Dionne
 * This is free software, under the GNU public license v2
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <FeatureMgr.h>

#define MainForm 1000
#define EnableB 2001

void DebugOff()
{
  DWord feature;

  FtrUnregister('gdbS', 0);

  FtrGet(sysFtrCreator, sysFtrNumROMVersion, &feature);
  if (feature >= 0x02000000) {
    (*(char*)257) = 0; /* Turn off debugging */
  }
}

void DebugOn()
{
  DWord feature;

  FtrSet('gdbS', 0, (DWord)0x12BEEF34);

  FtrGet(sysFtrCreator, sysFtrNumROMVersion, &feature);
  if (feature >= 0x02000000) {
    (*(char*)257) = 1; /* Turn on debugging */
  }
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
  short err;
  EventType e;
  int i;

  if (!cmd) {
    FrmGotoForm(MainForm);

    while(1) {
      EvtGetEvent(&e, -1);
      if (SysHandleEvent(&e)) continue;
      if (MenuHandleEvent((void *)0, &e, &err)) continue;

      switch (e.eType) {

      case frmLoadEvent:
        FrmSetActiveForm(FrmInitForm(e.data.frmLoad.formID));
        break;

      case frmOpenEvent:
	DebugOff();
        FrmDrawForm(FrmGetActiveForm());
        break;

      case ctlSelectEvent:
	if (e.data.ctlSelect.controlID == EnableB) {
	  if (e.data.ctlSelect.on) DebugOn();
	  else DebugOff();
	}
        break;

      case appStopEvent:
        return 0;

      default:
        FrmHandleEvent(FrmGetActiveForm(), &e);
      }
    }
  }
}
