/*  jpilot-Mail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <gtk/gtk.h>
#include "libplugin.h"
#include <pi-mail.h>
#include "mail.h"

gchar *hdr_items[] =
{
  "To:", "Cc:", "Bcc:", "Reply-To:"
};
#define HDR_ITEM_CNT 4

static void cb_not_yet(GtkWidget *widget,
			     gpointer   data)
{
  jpilot_logf(JP_LOG_DEBUG, "Mail: cb_not_yet\n");

  if (GTK_IS_WIDGET(data)) {
    gtk_widget_destroy(data);
  }
}

static void cb_editwin_destroy(GtkWidget *widget,
			     gpointer   data)
{
  jpilot_logf(JP_LOG_DEBUG, "Mail: cb_editwin_destroy\n");

}

void cb_mail_edit(GtkWidget *widget, gpointer   data)
{
  GtkWidget *window;
  GtkWidget *vbox;

  jpilot_logf(JP_LOG_DEBUG, "Mail: cb_mail_edit\n");

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size(GTK_WINDOW(window), 500, 300);
  gtk_container_set_border_width(GTK_CONTAINER(window), 10);
  gtk_window_set_title(GTK_WINDOW(window), "Edit Mail");

  gtk_signal_connect(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(cb_editwin_destroy), window);

  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), vbox);

  /* Buttons on top */
  {
    GtkWidget *button;
    GtkWidget *hbox_temp = gtk_hbox_new (FALSE, 0);

    gtk_box_pack_start(GTK_BOX(vbox), hbox_temp, FALSE, FALSE, 0);

    button = gtk_button_new_with_label("Send");
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(cb_not_yet), NULL);
    gtk_box_pack_start(GTK_BOX(hbox_temp), button, TRUE, TRUE, 0);

    button = gtk_button_new_with_label("Save");
    gtk_signal_connect(GTK_OBJECT(button), "clicked",
		       GTK_SIGNAL_FUNC(cb_not_yet), NULL);
    gtk_box_pack_start(GTK_BOX(hbox_temp), button, TRUE, TRUE, 0);
  }

  {
    GtkWidget *label;
    GtkWidget *hdr_vbox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hdr_vbox, FALSE, FALSE, 0);
    
    {
      GtkWidget *hdr_hbox = gtk_vbox_new(FALSE, 0);
      GtkWidget *hdr_combo;
      int i;
      gtk_box_pack_start(GTK_BOX(hdr_vbox), hdr_hbox, FALSE, FALSE, 0);

      hdr_combo = gtk_combo_new();
      gtk_box_pack_start(GTK_BOX(hdr_vbox), hdr_combo, TRUE, TRUE, 0);

      for(i = 0; i < HDR_ITEM_CNT; i++){
	GtkWidget *item = gtk_list_item_new_with_label(hdr_items[i]);
	gtk_combo_set_item_string(GTK_COMBO(hdr_combo),
				  GTK_ITEM(item), hdr_items[i]);
      }
      gtk_widget_show(hdr_combo);
    }
  }

  gtk_widget_show_all(window);
}

