#
#  $Id: Conduit.py,v 1.12 1999/08/09 21:59:13 rob Exp $
#
#  Copyright 1998-1999 Rob Tillotson <robt@debian.org>
#  All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee or royalty is
#  hereby granted, provided that the above copyright notice appear in
#  all copies and that both the copyright notice and this permission
#  notice appear in supporting documentation or portions thereof,
#  including modifications, that you you make.
#
#  THE AUTHOR ROB TILLOTSON DISCLAIMS ALL WARRANTIES WITH REGARD TO
#  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
#  AND FITNESS.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE!
#
"""Conduit API.
"""

__version__ = '$Id: Conduit.py,v 1.12 1999/08/09 21:59:13 rob Exp $'

__copyright__ = 'Copyright 1998-1999 Rob Tillotson <robt@debian.org>'


import sys
from Pyrite import Plugin

Error = 'Pyrite.Conduit.Error'

class Conduit(Plugin.Plugin):
    """Superclass for all conduits.
    """
    type = 'Conduit'
    
    def __init__(self, *a, **kw):
	apply(Plugin.Plugin.__init__, (self,)+a, kw)
	
    def __call__(self, *a, **kw):
	"""Invoke the conduit.
	"""
	pass

    def presync(self, *a, **kw):
	"""Do pre-sync stuff.

	Before synchronization starts, the synchronization manager
	calls each conduit's presync method so that it can do any
	pre-processing it needs to.  The intent of this, and the
	postsync function, is to allow conduits to move time-consuming
	operations out of the central synchronization loop so that
	serial connect time can be minimized.

	The presync method must not attempt to use the DLP connection.

	This method should return true if the conduit has any work to
	do during the sync pass, or false otherwise.  Conduits whose
	presync methods return false will be SKIPPED during the sync
	pass.
	"""
	return 1

    def postsync(self, *a, **kw):
	"""Do post-sync stuff.

	After synchronization is complete and the serial connection is
	closed, the synchronization manager calls each conduit's
	postsync method so that the conduit can do cleanup and post-
	processing.

	The postsync method must not attempt to use the DLP connection.
	"""
	pass
    
    def synchronize(self, remote, local, archive, fast=0):
	"""Generic synchronization logic, similar to that used by the
	Palm desktop.  Assumes that the parameters are Databases with
	the appropriate methods; note that, as dictated by the
	capabilities of each side of the connection, the sync process
	is not symmetrical (although its results are).  To make it
	easier to use this function as-is without overloading, there
	are several callbacks which may be used to provide conduit-
	specific behavior.
	"""
	pass
    
	    

			
		    
