/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SmallAnnotation
implements Annotation {
    private Object[] mappings;
    private int numMappings = 0;
    protected transient ChangeSupport changeSupport = null;

    public SmallAnnotation() {
    }

    public SmallAnnotation(int size) {
        this.mappings = new Object[size * 2];
    }

    public Object getProperty(Object key) {
        int keyHash = key.hashCode();
        if (this.mappings != null) {
            int i = 0;
            while (i < this.numMappings * 2) {
                if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                    return this.mappings[i + 1];
                }
                i += 2;
            }
        }
        throw new NoSuchElementException("Key " + key.toString() + " has no mapping");
    }

    public boolean containsProperty(Object key) {
        int keyHash = key.hashCode();
        if (this.mappings != null) {
            int i = 0;
            while (i < this.numMappings * 2) {
                if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                    return true;
                }
                i += 2;
            }
        }
        return false;
    }

    public void setProperty(Object key, Object value) throws ChangeVetoException {
        if (this.changeSupport != null) {
            Object oldValue = null;
            if (this.containsProperty(key)) {
                oldValue = this.getProperty(key);
            }
            ChangeEvent ce = new ChangeEvent(this, Annotation.PROPERTY, new Object[]{key, value}, new Object[]{key, oldValue});
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                this._setProperty(key, value);
                this.changeSupport.firePostChangeEvent(ce);
            }
        } else {
            this._setProperty(key, value);
        }
    }

    private void _setProperty(Object key, Object value) {
        if (this.mappings == null) {
            this.mappings = new Object[4];
        } else {
            int keyHash = key.hashCode();
            int i = 0;
            while (i < this.numMappings * 2) {
                if (keyHash == this.mappings[i].hashCode() && key.equals(this.mappings[i])) {
                    this.mappings[i + 1] = value;
                    return;
                }
                i += 2;
            }
        }
        int newPos = this.numMappings * 2;
        if (newPos + 1 >= this.mappings.length) {
            Object[] newMappings = new Object[this.mappings.length + 6];
            System.arraycopy(this.mappings, 0, newMappings, 0, this.mappings.length);
            this.mappings = newMappings;
        }
        this.mappings[newPos] = key;
        this.mappings[newPos + 1] = value;
        ++this.numMappings;
    }

    public Set keys() {
        return new KeySet();
    }

    public Map asMap() {
        return new EntryMap();
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    private class MapEntry
    implements Map.Entry {
        private int offset;

        private MapEntry(int offset) {
            this.offset = offset;
        }

        public Object getKey() {
            return SmallAnnotation.this.mappings[this.offset];
        }

        public Object getValue() {
            return SmallAnnotation.this.mappings[this.offset + 1];
        }

        public Object setValue(Object v) {
            throw new UnsupportedOperationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            boolean bl;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mo = (Map.Entry)o;
            if (this.getKey() == null) {
                if (mo.getKey() != null) return false;
                bl = true;
            } else {
                bl = this.getKey().equals(mo.getKey());
            }
            if (!bl) return false;
            if (this.getValue() == null) {
                if (mo.getValue() != null) return false;
                return true;
            }
            boolean bl2 = this.getValue().equals(mo.getValue());
            if (!bl2) return false;
            return true;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class EntryIterator
    implements Iterator {
        int pos = 0;

        private EntryIterator() {
        }

        public boolean hasNext() {
            return this.pos < SmallAnnotation.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallAnnotation.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return new MapEntry(offset);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public int size() {
            return SmallAnnotation.this.numMappings;
        }
    }

    private class EntryMap
    extends AbstractMap {
        private EntryMap() {
        }

        public Set entrySet() {
            return new EntrySet();
        }

        public Set keySet() {
            return new KeySet();
        }

        public boolean containsKey(Object key) {
            return SmallAnnotation.this.containsProperty(key);
        }

        public Object get(Object key) {
            if (SmallAnnotation.this.containsProperty(key)) {
                return SmallAnnotation.this.getProperty(key);
            }
            return null;
        }

        public int size() {
            return SmallAnnotation.this.numMappings;
        }
    }

    private class KeyIterator
    implements Iterator {
        int pos = 0;

        private KeyIterator() {
        }

        public boolean hasNext() {
            return this.pos < SmallAnnotation.this.numMappings;
        }

        public Object next() {
            if (this.pos >= SmallAnnotation.this.numMappings) {
                throw new NoSuchElementException();
            }
            int offset = this.pos * 2;
            ++this.pos;
            return SmallAnnotation.this.mappings[offset];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return SmallAnnotation.this.numMappings;
        }

        public boolean contains(Object o) {
            return SmallAnnotation.this.containsProperty(o);
        }
    }
}

