/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.Arrays;
import java.util.List;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class LightPairDPCursor
implements PairDPCursor {
    private int[] pos;
    private boolean flip;
    private SymbolList[] seqs;
    private double[][][] columns;
    private double[][][] emissions;
    protected BackPointer[][][] bPointers;
    protected int numStates;
    protected double[] zeroCol;
    protected BackPointer[] emptyBP;
    protected int[] depth;
    protected EmissionCache eCache;

    public LightPairDPCursor(SymbolList seq1, SymbolList seq2, int depth1, int depth2, int numStates, EmissionCache eCache) throws IllegalSymbolException {
        this.numStates = numStates;
        this.zeroCol = new double[this.numStates];
        int i = 0;
        while (i < this.zeroCol.length) {
            this.zeroCol[i] = Double.NaN;
            ++i;
        }
        this.emptyBP = new BackPointer[numStates];
        this.pos = new int[2];
        this.pos[0] = 0;
        this.pos[1] = 0;
        this.seqs = new SymbolList[2];
        this.seqs[0] = seq1;
        this.seqs[1] = seq2;
        this.depth = new int[2];
        this.depth[0] = depth1;
        this.depth[1] = depth2;
        this.eCache = eCache;
        boolean bl = this.flip = this.seqs[1].length() > this.seqs[0].length();
        if (this.flip) {
            this.columns = new double[this.depth[0]][this.seqs[1].length() + 2][numStates];
            this.emissions = new double[this.depth[0]][this.seqs[1].length() + 2][];
            this.bPointers = new BackPointer[this.depth[0]][this.seqs[1].length() + 2][numStates];
        } else {
            this.columns = new double[this.depth[1]][this.seqs[0].length() + 2][numStates];
            this.emissions = new double[this.depth[1]][this.seqs[0].length() + 2][];
            this.bPointers = new BackPointer[this.depth[1]][this.seqs[0].length() + 2][numStates];
        }
        int i2 = 0;
        while (i2 < this.columns.length) {
            double[][] ci = this.columns[i2];
            int j = 0;
            while (j < ci.length) {
                double[] cj = ci[j];
                int k = 0;
                while (k < cj.length) {
                    cj[k] = Double.NaN;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        this.calcEmissions(this.emissions[0]);
    }

    public int[] getDepth() {
        return this.depth;
    }

    public boolean hasNext() {
        int i = this.flip ? 0 : 1;
        return this.pos[i] <= this.seqs[i].length() + 1;
    }

    public Cell[][] press() {
        Cell[][] cells = new Cell[this.depth[0]][this.depth[1]];
        int i = 0;
        while (i < cells.length) {
            Cell[] ci = cells[i];
            int j = 0;
            while (j < ci.length) {
                ci[j] = new Cell();
                ++j;
            }
            ++i;
        }
        return cells;
    }

    public void next(Cell[][] cells) throws IllegalSymbolException {
        if (this.flip) {
            int i = 0;
            while (i < this.depth[0]) {
                int ii = this.pos[0] - i;
                boolean outI = ii < 0 || ii > this.seqs[0].length() + 1;
                Cell[] cellI = cells[i];
                double[][] columnsI = this.columns[i];
                double[][] emissionsI = this.emissions[i];
                BackPointer[][] bPointersI = this.bPointers[i];
                int j = 0;
                while (j < this.depth[1]) {
                    int jj = this.pos[1] - j;
                    boolean outJ = jj < 0 || jj > this.seqs[1].length() + 1;
                    Cell c = cellI[j];
                    if (outI || outJ) {
                        c.scores = this.zeroCol;
                        c.emissions = this.zeroCol;
                        c.backPointers = this.emptyBP;
                    } else {
                        c.scores = columnsI[jj];
                        c.emissions = emissionsI[jj];
                        c.backPointers = bPointersI[jj];
                    }
                    ++j;
                }
                ++i;
            }
            if (this.pos[1] <= this.seqs[1].length()) {
                this.pos[1] = this.pos[1] + 1;
            } else {
                this.pos[1] = 0;
                this.pos[0] = this.pos[0] + 1;
                int depth = this.depth[0];
                double[][] tempC = this.columns[depth - 1];
                double[][] tempE = this.emissions[depth - 1];
                BackPointer[][] tempBP = this.bPointers[depth - 1];
                int i2 = 1;
                while (i2 < depth) {
                    this.columns[i2] = this.columns[i2 - 1];
                    this.emissions[i2] = this.emissions[i2 - 1];
                    this.bPointers[i2] = this.bPointers[i2 - 1];
                    ++i2;
                }
                this.columns[0] = tempC;
                this.emissions[0] = tempE;
                this.bPointers[0] = tempBP;
                this.calcEmissions(tempE);
            }
        } else {
            int i = 0;
            while (i < this.depth[1]) {
                int ii = this.pos[1] - i;
                boolean outI = ii < 0 || ii > this.seqs[1].length() + 1;
                double[][] columnsI = this.columns[i];
                double[][] emissionsI = this.emissions[i];
                BackPointer[][] bPointersI = this.bPointers[i];
                int j = 0;
                while (j < this.depth[0]) {
                    int jj = this.pos[0] - j;
                    boolean outJ = jj < 0 || jj > this.seqs[0].length() + 1;
                    Cell c = cells[j][i];
                    if (outI || outJ) {
                        c.scores = this.zeroCol;
                        c.emissions = this.zeroCol;
                        c.backPointers = this.emptyBP;
                    } else {
                        c.scores = columnsI[jj];
                        c.emissions = emissionsI[jj];
                        c.backPointers = bPointersI[jj];
                    }
                    ++j;
                }
                ++i;
            }
            if (this.pos[0] <= this.seqs[0].length()) {
                this.pos[0] = this.pos[0] + 1;
            } else {
                this.pos[0] = 0;
                this.pos[1] = this.pos[1] + 1;
                int depth = this.depth[1];
                double[][] tempC = this.columns[depth - 1];
                double[][] tempE = this.emissions[depth - 1];
                BackPointer[][] tempBP = this.bPointers[depth - 1];
                int i3 = 1;
                while (i3 < depth) {
                    this.columns[i3] = this.columns[i3 - 1];
                    this.emissions[i3] = this.emissions[i3 - 1];
                    this.bPointers[i3] = this.bPointers[i3 - 1];
                    ++i3;
                }
                this.columns[0] = tempC;
                this.emissions[0] = tempE;
                this.bPointers[0] = tempBP;
                this.calcEmissions(tempE);
            }
        }
    }

    private void calcEmissions(double[][] em) throws IllegalSymbolException {
        if (this.flip) {
            Symbol[] symL = new Symbol[2];
            List<Symbol> symList = Arrays.asList(symL);
            int i = this.pos[0];
            symL[0] = i < 1 || i > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(i);
            int j = 0;
            while (j <= this.seqs[1].length() + 1) {
                symL[1] = j < 1 || j > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(j);
                em[j] = this.eCache.getEmissions(symList);
                ++j;
            }
        } else {
            Symbol[] symL = new Symbol[2];
            List<Symbol> symList = Arrays.asList(symL);
            int j = this.pos[1];
            symL[1] = j < 1 || j > this.seqs[1].length() ? AlphabetManager.getGapSymbol() : this.seqs[1].symbolAt(j);
            int i = 0;
            while (i <= this.seqs[0].length() + 1) {
                symL[0] = i < 1 || i > this.seqs[0].length() ? AlphabetManager.getGapSymbol() : this.seqs[0].symbolAt(i);
                em[i] = this.eCache.getEmissions(symList);
                ++i;
            }
        }
    }
}

