/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.DistributionLogo;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class BarLogoPainter
implements LogoPainter {
    public void paintLogo(Graphics g, DistributionLogo sl) {
        Graphics2D g2 = (Graphics2D)g;
        Distribution dis = sl.getDistribution();
        SymbolStyle style = sl.getStyle();
        Rectangle bounds = sl.getBounds();
        double width = bounds.getWidth();
        double stepWidth = width / (double)((FiniteAlphabet)dis.getAlphabet()).size();
        double height = bounds.getHeight();
        double scale = height * (sl.totalInformation() / sl.totalBits());
        double w = 0.0;
        Iterator i = ((FiniteAlphabet)dis.getAlphabet()).iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            double rh = 0.0;
            try {
                rh = dis.getWeight(s) * scale;
            }
            catch (IllegalSymbolException ire) {
                throw new BioError(ire, "State alphabet has changed while painting");
            }
            Rectangle2D.Double outline = new Rectangle2D.Double(w, height - rh, stepWidth, rh);
            try {
                g2.setPaint(style.fillPaint(s));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.black);
            }
            g2.fill(outline);
            try {
                g2.setPaint(style.outlinePaint(s));
            }
            catch (IllegalSymbolException ire) {
                g2.setPaint(Color.gray);
            }
            g2.draw(outline);
            w += stepWidth;
        }
    }
}

