/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRendererWrapper;
import org.biojava.bio.gui.sequence.SubSequenceRenderContext;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.symbol.Alignment;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class AlignmentRenderer
extends SequenceRendererWrapper {
    public static ChangeType LABEL = new ChangeType("The label used to select the Alignment component to render has changed.", "org.biojava.bio.gui.sequence.AlignmentRenderer", "LABEL", SequenceRenderContext.LAYOUT);
    private Object label;

    public void setLabel(Object label) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, LABEL, label, this.label);
            ChangeSupport changeSupport = cs = this.getChangeSupport(LABEL);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                this.label = label;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.label = label;
        }
    }

    public Object getLabel() {
        return this.label;
    }

    public double getDepth(SequenceRenderContext ctx) {
        SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
        return super.getDepth(subctx);
    }

    public double getMinimumLeader(SequenceRenderContext ctx) {
        SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
        return super.getMinimumLeader(subctx);
    }

    public double getMinimumTrailer(SequenceRenderContext ctx) {
        SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
        return super.getMinimumTrailer(subctx);
    }

    public void paint(Graphics2D g, SequenceRenderContext ctx) {
        SequenceRenderContext subctx = this.contextForLabel(ctx, this.getLabel());
        super.paint(g, subctx);
    }

    public SequenceRenderContext contextForLabel(SequenceRenderContext src, Object label) {
        Alignment ali = (Alignment)src.getSymbols();
        SymbolList sl = ali.symbolListForLabel(label);
        FeatureHolder features = null;
        if (sl instanceof FeatureHolder) {
            features = (FeatureHolder)((Object)sl);
        }
        return new SubSequenceRenderContext(src, sl, features, null);
    }
}

