/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.SymbolList;

public class SymbolSequenceRenderer
implements SequenceRenderer {
    private double depth = 25.0;

    public double getDepth(SequenceRenderContext src) {
        return this.depth + 1.0;
    }

    public double getMinimumLeader(SequenceRenderContext src) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext src) {
        return 0.0;
    }

    public void paint(Graphics2D g, SequenceRenderContext src) {
        SymbolList seq = src.getSymbols();
        int direction = src.getDirection();
        g.setFont(src.getFont());
        Rectangle oldClip = g.getClipBounds();
        g.setColor(Color.black);
        double scale = src.getScale();
        Rectangle2D maxBounds = g.getFont().getMaxCharBounds(g.getFontRenderContext());
        if (src.getScale() >= maxBounds.getWidth() * 0.3 && src.getScale() >= maxBounds.getHeight() * 0.3) {
            int trailing;
            int leading;
            double fudgeAcross = 0.0;
            double fudgeDown = 0.0;
            if (direction == 0) {
                fudgeAcross = -maxBounds.getCenterX();
                fudgeDown = this.depth * 0.5 - maxBounds.getCenterY();
            } else {
                fudgeAcross = this.depth * 0.5 - maxBounds.getCenterX();
                fudgeDown = scale * 0.5 - maxBounds.getCenterY();
            }
            int symOffset = src.getRange().getMin();
            double graphOffset = src.sequenceToGraphics(symOffset);
            if (src.getDirection() == 0) {
                leading = src.graphicsToSequence(oldClip.getMinX());
                trailing = src.graphicsToSequence(oldClip.getMaxX());
            } else {
                leading = src.graphicsToSequence(oldClip.getMinY());
                trailing = src.graphicsToSequence(oldClip.getMaxY());
            }
            int min = Math.max(src.getRange().getMin(), leading);
            int max = Math.min(src.getRange().getMax(), trailing + 1);
            int sPos = min;
            while (sPos <= max) {
                double gPos = src.sequenceToGraphics(sPos + 1);
                char c = seq.symbolAt(sPos).getToken();
                if (direction == 0) {
                    g.drawString(String.valueOf(c), (int)(gPos + fudgeAcross), (int)fudgeDown);
                    if (sPos == 10) {
                        g.draw(new Rectangle2D.Double(gPos, 0.0, src.getScale(), 10.0));
                    }
                } else {
                    g.drawString(String.valueOf(c), (int)fudgeAcross, (int)(gPos + fudgeDown));
                }
                ++sPos;
            }
        }
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext src, MouseEvent me, List path) {
        path.add(this);
        int sPos = src.graphicsToSequence(me.getPoint());
        return new SequenceViewerEvent(this, null, sPos, me, path);
    }
}

