/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import org.biojava.bio.program.gff.GFFRecord;

public interface GFFRecordFilter {
    public static final GFFRecordFilter ACCEPT_ALL = new AcceptAll();

    public boolean accept(GFFRecord var1);

    public static class FeatureFilter
    implements GFFRecordFilter {
        private String feature;

        public void setFeature(String feature) {
            this.feature = feature;
        }

        public String getFeature() {
            return this.feature;
        }

        public boolean accept(GFFRecord record) {
            return record.getFeature().equals(this.feature);
        }
    }

    public static class SourceFilter
    implements GFFRecordFilter {
        private String source;

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public boolean accept(GFFRecord record) {
            return record.getSource().equals(this.source);
        }
    }

    public static class SequenceFilter
    implements GFFRecordFilter {
        private String seqName;

        public String getSeqName() {
            return this.seqName;
        }

        public void setSeqName(String seqName) {
            this.seqName = seqName;
        }

        public boolean accept(GFFRecord record) {
            return record.getSeqName().equals(this.seqName);
        }
    }

    public static class AcceptAll
    implements GFFRecordFilter {
        public boolean accept(GFFRecord record) {
            return true;
        }
    }
}

