/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.ssbind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.search.SearchBuilder;
import org.biojava.bio.program.ssbind.AlphabetResolver;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.search.SeqSimilaritySearchSubHit;
import org.biojava.bio.search.SequenceDBSearchHit;
import org.biojava.bio.search.SequenceDBSearchResult;
import org.biojava.bio.search.SequenceDBSearchSubHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBInstallation;
import org.biojava.bio.seq.io.TokenParser;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.SimpleAlignment;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class BlastLikeSearchBuilder
implements SearchBuilder {
    private SequenceDBInstallation subjectDBs;
    private SequenceDB subjectDB;
    private SequenceDB querySeqHolder;
    private SymbolList querySeq;
    private Annotation hitAnnotation;
    private Annotation resultAnnotation;
    private Map resultPreAnnotation;
    private Map searchParameters;
    private Map hitData;
    private Map subHitData;
    private AlphabetResolver alphaResolver;
    private TokenParser tokenParser;
    private StringBuffer tokenBuffer;
    private List hits;
    private List subHits;
    private SeqSimilaritySearchSubHit[] subs;
    private List target;
    private boolean moreSearchesAvailable = false;

    public BlastLikeSearchBuilder(List target) {
        this.target = target;
        this.resultPreAnnotation = new HashMap();
        this.searchParameters = new HashMap();
        this.hitData = new HashMap();
        this.subHitData = new HashMap();
        this.alphaResolver = new AlphabetResolver();
        this.tokenBuffer = new StringBuffer(1024);
    }

    public SeqSimilaritySearchResult makeSearchResult() throws BioException {
        return new SequenceDBSearchResult(this.subjectDB, this.searchParameters, this.querySeq, this.resultAnnotation, this.hits);
    }

    public SequenceDB getQuerySeqHolder() {
        return this.querySeqHolder;
    }

    public void setQuerySeqHolder(SequenceDB querySeqHolder) {
        this.querySeqHolder = querySeqHolder;
    }

    public SequenceDBInstallation getSubjectDBInstallation() {
        return this.subjectDBs;
    }

    public void setSubjectDBInstallation(SequenceDBInstallation subjectDBs) {
        this.subjectDBs = subjectDBs;
    }

    public boolean getMoreSearches() {
        return this.moreSearchesAvailable;
    }

    public void setMoreSearches(boolean value) {
        this.moreSearchesAvailable = value;
    }

    public void startSearch() {
        this.hits = new ArrayList();
    }

    public void endSearch() {
        try {
            this.resultAnnotation = this.makeAnnotation(this.resultPreAnnotation);
            this.target.add(this.makeSearchResult());
        }
        catch (BioException be) {
            System.err.println("Failed to build SeqSimilaritySearchResult: ");
            be.printStackTrace();
        }
    }

    public void startHeader() {
        this.resultPreAnnotation.clear();
        this.searchParameters.clear();
    }

    public void endHeader() {
    }

    public void startHit() {
        this.hitData.clear();
        this.subHits = new ArrayList();
    }

    public void endHit() {
        this.hits.add(this.makeHit());
    }

    public void startSubHit() {
        this.subHitData.clear();
    }

    public void endSubHit() {
        try {
            this.subHits.add(this.makeSubHit());
        }
        catch (BioException be) {
            System.err.println("Failed to build SubHit: ");
            be.printStackTrace();
        }
    }

    public void addSearchProperty(Object key, Object value) {
        this.resultPreAnnotation.put(key, value);
    }

    public void addHitProperty(Object key, Object value) {
        this.hitData.put(key, value);
    }

    public void addSubHitProperty(Object key, Object value) {
        this.subHitData.put(key, value);
    }

    public void setQuerySeq(String querySeqId) throws BioException {
        if (this.querySeqHolder == null) {
            throw new BioException("Running BlastLikeSearchBuilder with null query SequenceDB");
        }
        try {
            this.querySeq = this.querySeqHolder.getSequence(querySeqId);
        }
        catch (BioException be) {
            throw new BioException(be, "Failed to retrieve query sequence from holder using ID: " + querySeqId);
        }
    }

    public void setSubjectDB(String subjectDBName) throws BioException {
        if (this.subjectDBs == null) {
            throw new BioException("Running BlastLikeSearchBuilder with null subject SequenceDBInstallation");
        }
        this.subjectDB = this.subjectDBs.getSequenceDB(subjectDBName);
        if (this.subjectDB == null) {
            throw new BioException("Failed to retrieve database from installation using ID: " + subjectDBName);
        }
    }

    private SeqSimilaritySearchHit makeHit() {
        double sc = Double.NaN;
        double ev = Double.NaN;
        double pv = Double.NaN;
        this.subs = this.subHits.toArray(new SeqSimilaritySearchSubHit[this.subHits.size() - 1]);
        Arrays.sort(this.subs, SeqSimilaritySearchSubHit.byScore);
        sc = this.subs[this.subs.length - 1].getScore();
        ev = this.subs[this.subs.length - 1].getEValue();
        pv = this.subs[this.subs.length - 1].getPValue();
        StrandedFeature.Strand bestQueryStrand = this.subs[this.subs.length - 1].getQueryStrand();
        StrandedFeature.Strand bestSubjectStrand = this.subs[this.subs.length - 1].getSubjectStrand();
        int qStart = 0;
        int qEnd = 0;
        int sStart = 0;
        int sEnd = 0;
        int i = this.subs.length;
        while (--i >= 0) {
            if (!this.subs[i].getSubjectStrand().equals(bestSubjectStrand)) continue;
            if (sStart == 0 || sStart > this.subs[i].getSubjectStart()) {
                sStart = this.subs[i].getSubjectStart();
                qStart = this.subs[i].getQueryStart();
            }
            if (sEnd >= this.subs[i].getSubjectEnd()) continue;
            sEnd = this.subs[i].getSubjectEnd();
            qEnd = this.subs[i].getQueryEnd();
        }
        String hitId = (String)this.hitData.get("HitId");
        return new SequenceDBSearchHit(sc, ev, pv, qStart, qEnd, bestQueryStrand, sStart, sEnd, bestSubjectStrand, hitId, this.makeAnnotation(this.hitData), this.subHits);
    }

    private SeqSimilaritySearchSubHit makeSubHit() throws BioException {
        int swap;
        StrandedFeature.Strand qStrand = StrandedFeature.POSITIVE;
        StrandedFeature.Strand sStrand = StrandedFeature.POSITIVE;
        if (this.subHitData.containsKey("queryStrand") && this.subHitData.get("queryStrand").equals("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectStrand") && this.subHitData.get("subjectStrand").equals("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("queryFrame") && ((String)this.subHitData.get("queryFrame")).startsWith("minus")) {
            qStrand = StrandedFeature.NEGATIVE;
        }
        if (this.subHitData.containsKey("subjectFrame") && ((String)this.subHitData.get("subjectFrame")).startsWith("minus")) {
            sStrand = StrandedFeature.NEGATIVE;
        }
        int qStart = Integer.parseInt((String)this.subHitData.get("querySequenceStart"));
        int qEnd = Integer.parseInt((String)this.subHitData.get("querySequenceEnd"));
        int sStart = Integer.parseInt((String)this.subHitData.get("subjectSequenceStart"));
        int sEnd = Integer.parseInt((String)this.subHitData.get("subjectSequenceEnd"));
        if (qStrand == StrandedFeature.NEGATIVE) {
            swap = qStart;
            qStart = qEnd;
            qEnd = swap;
        }
        if (sStrand == StrandedFeature.NEGATIVE) {
            swap = qStart;
            sStart = sEnd;
            sEnd = swap;
        }
        double sc = Double.NaN;
        double ev = Double.NaN;
        double pv = Double.NaN;
        if (this.subHitData.containsKey("score")) {
            sc = Double.parseDouble((String)this.subHitData.get("score"));
        }
        if (this.subHitData.containsKey("expectValue")) {
            ev = Double.parseDouble((String)this.subHitData.get("expectValue"));
        }
        if (this.subHitData.containsKey("pValue")) {
            pv = Double.parseDouble((String)this.subHitData.get("pValue"));
        }
        if (this.tokenParser == null) {
            String identifier;
            if (this.subHitData.containsKey("hitSequenceType")) {
                identifier = (String)this.subHitData.get("hitSequenceType");
            } else if (this.resultPreAnnotation.containsKey("program")) {
                identifier = (String)this.resultPreAnnotation.get("program");
            } else {
                throw new BioException("Failed to determine sequence type");
            }
            FiniteAlphabet alpha = this.alphaResolver.resolveAlphabet(identifier);
            this.tokenParser = new TokenParser(alpha);
        }
        HashMap<String, SymbolList> labelMap = new HashMap<String, SymbolList>();
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append((String)this.subHitData.get("querySequence"));
        labelMap.put("Query", this.tokenParser.parse(this.tokenBuffer.toString()));
        this.tokenBuffer.setLength(0);
        this.tokenBuffer.append((String)this.subHitData.get("subjectSequence"));
        labelMap.put((String)this.hitData.get("HitId"), this.tokenParser.parse(this.tokenBuffer.toString()));
        return new SequenceDBSearchSubHit(sc, ev, pv, qStart, qEnd, qStrand, sStart, sEnd, sStrand, new SimpleAlignment(labelMap));
    }

    private Annotation makeAnnotation(Map preAnnotation) {
        SmallAnnotation annotation = new SmallAnnotation();
        Set annotationKeySet = preAnnotation.keySet();
        Iterator ksi = annotationKeySet.iterator();
        while (ksi.hasNext()) {
            Object annotationKey = ksi.next();
            Object annotationValue = preAnnotation.get(annotationKey);
            try {
                annotation.setProperty(annotationKey, annotationValue);
            }
            catch (ChangeVetoException cve) {
                System.err.println("Failed to add mapping to Annotation:");
                cve.printStackTrace();
            }
        }
        return annotation;
    }
}

