/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Comparator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Alignment;

public interface SeqSimilaritySearchSubHit {
    public static final String QUERY_LABEL = "Query";
    public static final ByScoreComparator byScore = new ByScoreComparator();
    public static final BySubjectStartComparator bySubjectStart = new BySubjectStartComparator();

    public double getScore();

    public double getPValue();

    public double getEValue();

    public int getQueryStart();

    public int getQueryEnd();

    public StrandedFeature.Strand getQueryStrand();

    public int getSubjectStart();

    public int getSubjectEnd();

    public StrandedFeature.Strand getSubjectStrand();

    public Alignment getAlignment();

    public static final class BySubjectStartComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SeqSimilaritySearchSubHit h1 = (SeqSimilaritySearchSubHit)o1;
            SeqSimilaritySearchSubHit h2 = (SeqSimilaritySearchSubHit)o2;
            if (h1.getSubjectStart() > h2.getSubjectStart()) {
                return 1;
            }
            if (h1.getSubjectStart() < h2.getSubjectStart()) {
                return -1;
            }
            return 0;
        }
    }

    public static final class ByScoreComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            SeqSimilaritySearchSubHit h1 = (SeqSimilaritySearchSubHit)o1;
            SeqSimilaritySearchSubHit h2 = (SeqSimilaritySearchSubHit)o2;
            if (h1.getScore() > h2.getScore()) {
                return 1;
            }
            if (h1.getScore() < h2.getScore()) {
                return -1;
            }
            return 0;
        }
    }
}

