/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchHit;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SequenceDBSearchHit
extends AbstractChangeable
implements SeqSimilaritySearchHit,
Annotatable {
    private String sequenceID;
    private double score;
    private double pValue;
    private double eValue;
    private int queryStart;
    private int queryEnd;
    private StrandedFeature.Strand queryStrand;
    private int subjectStart;
    private int subjectEnd;
    private StrandedFeature.Strand subjectStrand;
    private List subHits;
    private Annotation annotation;

    public SequenceDBSearchHit(double score, double eValue, double pValue, int queryStart, int queryEnd, StrandedFeature.Strand queryStrand, int subjectStart, int subjectEnd, StrandedFeature.Strand subjectStrand, String sequenceID, Annotation annotation, List subHits) {
        Contract.pre(!Double.isNaN(score), "score was NaN");
        Contract.pre(sequenceID != null, "sequenceID was null");
        Contract.pre(queryStrand != null, "query strand was null");
        Contract.pre(subjectStrand != null, "subject strand was null");
        Contract.pre(annotation != null, "annotation was null");
        Contract.pre(subHits != null, "subHits was null");
        this.sequenceID = sequenceID;
        this.score = score;
        this.eValue = eValue;
        this.pValue = pValue;
        this.queryStart = queryStart;
        this.queryEnd = queryEnd;
        this.queryStrand = queryStrand;
        this.subjectStart = subjectStart;
        this.subjectEnd = subjectEnd;
        this.subjectStrand = subjectStrand;
        this.subHits = subHits;
        this.annotation = annotation;
        this.annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public double getScore() {
        return this.score;
    }

    public double getPValue() {
        return this.pValue;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public StrandedFeature.Strand getQueryStrand() {
        return this.queryStrand;
    }

    public int getSubjectStart() {
        return this.subjectStart;
    }

    public int getSubjectEnd() {
        return this.subjectEnd;
    }

    public StrandedFeature.Strand getSubjectStrand() {
        return this.subjectStrand;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public List getSubHits() {
        return Collections.unmodifiableList(this.subHits);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchHit that = (SequenceDBSearchHit)other;
        if (!ObjectUtil.equals(this.score, that.score)) {
            return false;
        }
        if (!ObjectUtil.equals(this.pValue, that.pValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.eValue, that.eValue)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceID, that.sequenceID)) {
            return false;
        }
        return ObjectUtil.equals(this.subHits, that.subHits);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.score);
        hc = ObjectUtil.hashCode(hc, this.pValue);
        hc = ObjectUtil.hashCode(hc, this.eValue);
        hc = ObjectUtil.hashCode(hc, this.sequenceID);
        hc = ObjectUtil.hashCode(hc, this.subHits);
        return hc;
    }

    public String toString() {
        return "SequenceDBSearchHit to " + this.getSequenceID() + " with score " + this.getScore();
    }
}

