/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.OptimizableFilter;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;

public interface FeatureFilter
extends Serializable {
    public static final FeatureFilter all = new AcceptAllFilter();
    public static final FeatureFilter none = new AcceptNoneFilter();

    public boolean accept(Feature var1);

    public static final class StrandFilter
    implements OptimizableFilter {
        private StrandedFeature.Strand strand;

        public StrandFilter(StrandedFeature.Strand strand) {
            this.strand = strand;
        }

        public StrandedFeature.Strand getStrand() {
            return this.strand;
        }

        public boolean accept(Feature f) {
            if (f instanceof StrandedFeature) {
                StrandedFeature sf = (StrandedFeature)f;
                return sf.getStrand() == this.strand;
            }
            return this.strand == StrandedFeature.UNKNOWN;
        }

        public boolean equals(Object o) {
            return o instanceof StrandFilter && ((StrandFilter)o).getStrand() == this.getStrand();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof StrandFilter && ((StrandFilter)filt).getStrand() == this.getStrand();
        }
    }

    public static final class HasAnnotation
    implements FeatureFilter {
        private Object key;

        public HasAnnotation(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean accept(Feature f) {
            Annotation ann = f.getAnnotation();
            try {
                Object v = ann.getProperty(this.key);
                return true;
            }
            catch (NoSuchElementException nsee) {
                return false;
            }
        }

        public boolean equals(Object o) {
            return o instanceof HasAnnotation && ((HasAnnotation)o).getKey().equals(this.getKey());
        }

        public int hashCode() {
            return this.getKey().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof HasAnnotation && !this.getKey().equals(((HasAnnotation)filt).getKey());
        }
    }

    public static final class ByAnnotation
    implements OptimizableFilter {
        private Object key;
        private Object value;

        public ByAnnotation(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean accept(Feature f) {
            Annotation ann = f.getAnnotation();
            try {
                Object v = ann.getProperty(this.key);
                if (v == null) {
                    return this.value == null;
                }
                return v.equals(this.value);
            }
            catch (NoSuchElementException nsee) {
                return false;
            }
        }

        public boolean equals(Object o) {
            return o instanceof ByAnnotation && ((ByAnnotation)o).getKey().equals(this.getKey()) && ((ByAnnotation)o).getValue().equals(this.getValue());
        }

        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof ByAnnotation && (!this.getKey().equals(((ByAnnotation)filt).getKey()) || !this.getValue().equals(((ByAnnotation)filt).getValue()));
        }

        public String toString() {
            return this.getKey() + " == " + this.getValue();
        }
    }

    public static final class Or
    implements OptimizableFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public Or(FeatureFilter c1, FeatureFilter c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) || this.c2.accept(f);
        }

        public boolean equals(Object o) {
            return o instanceof Or && (((Or)o).getChild1().equals(this.getChild1()) && ((Or)o).getChild2().equals(this.getChild2()) || ((Or)o).getChild1().equals(this.getChild2()) && ((Or)o).getChild2().equals(this.getChild1()));
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return FilterUtils.areProperSubset(this.getChild1(), sup) && FilterUtils.areProperSubset(this.getChild2(), sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || FilterUtils.areDisjoint(this.getChild1(), filt) && FilterUtils.areDisjoint(this.getChild2(), filt);
        }

        public String toString() {
            return "Or(" + this.c1 + " , " + this.c2 + ")";
        }
    }

    public static final class AndNot
    implements FeatureFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public AndNot(FeatureFilter c1, FeatureFilter c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) && !this.c2.accept(f);
        }

        public boolean equals(Object o) {
            return o instanceof AndNot && ((AndNot)o).getChild1().equals(this.getChild1()) && ((AndNot)o).getChild2().equals(this.getChild2());
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public String toString() {
            return "AndNot(" + this.c1 + " , " + this.c2 + ")";
        }
    }

    public static final class And
    implements OptimizableFilter {
        FeatureFilter c1;
        FeatureFilter c2;

        public FeatureFilter getChild1() {
            return this.c1;
        }

        public FeatureFilter getChild2() {
            return this.c2;
        }

        public And(FeatureFilter c1, FeatureFilter c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean accept(Feature f) {
            return this.c1.accept(f) && this.c2.accept(f);
        }

        public boolean equals(Object o) {
            return o instanceof And && (((And)o).getChild1().equals(this.getChild1()) && ((And)o).getChild2().equals(this.getChild2()) || ((And)o).getChild1().equals(this.getChild2()) && ((And)o).getChild2().equals(this.getChild1()));
        }

        public int hashCode() {
            return this.getChild1().hashCode() ^ this.getChild2().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return FilterUtils.areProperSubset(this.getChild1(), sup) || FilterUtils.areProperSubset(this.getChild2(), sup);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || FilterUtils.areDisjoint(this.getChild1(), filt) || FilterUtils.areDisjoint(this.getChild2(), filt);
        }

        public String toString() {
            return "And(" + this.c1 + " , " + this.c2 + ")";
        }
    }

    public static final class Not
    implements OptimizableFilter {
        FeatureFilter child;

        public FeatureFilter getChild() {
            return this.child;
        }

        public Not(FeatureFilter child) {
            this.child = child;
        }

        public boolean accept(Feature f) {
            return !this.child.accept(f);
        }

        public boolean equals(Object o) {
            return o instanceof Not && ((Not)o).getChild().equals(this.getChild());
        }

        public int hashCode() {
            return this.getChild().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof Not) {
                FeatureFilter supC = ((Not)sup).getChild();
                FilterUtils.areProperSubset(supC, this.getChild());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return FilterUtils.areProperSubset(filt, this.getChild());
        }

        public String toString() {
            return "Not(" + this.child + ")";
        }
    }

    public static final class OverlapsLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public OverlapsLocation(Location loc) {
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.overlaps(f.getLocation());
        }

        public boolean equals(Object o) {
            return o instanceof OverlapsLocation && ((OverlapsLocation)o).getLocation().equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof OverlapsLocation) {
                Location supL = ((OverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ContainedByLocation) {
                Location loc = ((ContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "Overlaps(" + this.loc + ")";
        }
    }

    public static final class ContainedByLocation
    implements OptimizableFilter {
        private Location loc;

        public Location getLocation() {
            return this.loc;
        }

        public ContainedByLocation(Location loc) {
            this.loc = loc;
        }

        public boolean accept(Feature f) {
            return this.loc.contains(f.getLocation());
        }

        public boolean equals(Object o) {
            return o instanceof ContainedByLocation && ((ContainedByLocation)o).getLocation().equals(this.getLocation());
        }

        public int hashCode() {
            return this.getLocation().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ContainedByLocation) {
                Location supL = ((ContainedByLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            if (sup instanceof OverlapsLocation) {
                Location supL = ((OverlapsLocation)sup).getLocation();
                return supL.contains(this.getLocation());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            if (filt instanceof ContainedByLocation) {
                Location loc = ((ContainedByLocation)filt).getLocation();
                return !this.getLocation().overlaps(loc);
            }
            if (filt instanceof OverlapsLocation) {
                Location filtL = ((OverlapsLocation)filt).getLocation();
                return !filtL.overlaps(this.getLocation());
            }
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ContainedBy(" + this.loc + ")";
        }
    }

    public static final class ByClass
    implements OptimizableFilter {
        private Class clazz;

        public ByClass(Class clazz) {
            this.clazz = clazz;
        }

        public boolean accept(Feature f) {
            return this.clazz.isInstance(f);
        }

        public Class getTestClass() {
            return this.clazz;
        }

        public boolean equals(Object o) {
            return o instanceof ByClass && ((ByClass)o).getTestClass() == this.getTestClass();
        }

        public int hashCode() {
            return this.getTestClass().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            if (sup instanceof ByClass) {
                Class supC = ((ByClass)sup).getTestClass();
                return supC.isAssignableFrom(this.getTestClass());
            }
            return sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter feat) {
            if (feat instanceof ByClass) {
                Class<?> featC = ((ByClass)feat).getClass();
                return !featC.isAssignableFrom(this.getClass()) && !this.getClass().isAssignableFrom(featC);
            }
            return feat instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "ByClass(" + this.clazz.getName() + ")";
        }
    }

    public static final class BySource
    implements OptimizableFilter {
        private String source;

        public String getSource() {
            return this.source;
        }

        public BySource(String source) {
            this.source = source;
        }

        public boolean accept(Feature f) {
            return this.source.equals(f.getSource());
        }

        public boolean equals(Object o) {
            return o instanceof BySource && ((BySource)o).getSource().equals(this.getSource());
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup) || sup instanceof AcceptAllFilter;
        }

        public int hashCode() {
            return this.getSource().hashCode();
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof BySource && !this.getSource().equals(((BySource)filt).getSource());
        }

        public String toString() {
            return "BySource(" + this.source + ")";
        }
    }

    public static final class ByType
    implements OptimizableFilter {
        private String type;

        public String getType() {
            return this.type;
        }

        public ByType(String type) {
            this.type = type;
        }

        public boolean accept(Feature f) {
            return this.type.equals(f.getType());
        }

        public boolean equals(Object o) {
            return o instanceof ByType && ((ByType)o).getType().equals(this.getType());
        }

        public int hashCode() {
            return this.getType().hashCode();
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return this.equals(sup) || sup instanceof AcceptAllFilter;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter || filt instanceof ByType && !this.getType().equals(((ByType)filt).getType());
        }

        public String toString() {
            return "ByType(" + this.type + ")";
        }
    }

    public static final class AcceptNoneFilter
    implements OptimizableFilter {
        public boolean accept(Feature f) {
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof AcceptNoneFilter;
        }

        public int hashCode() {
            return 1;
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return true;
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return true;
        }

        public String toString() {
            return "None";
        }
    }

    public static final class AcceptAllFilter
    implements OptimizableFilter {
        public boolean accept(Feature f) {
            return true;
        }

        public boolean equals(Object o) {
            return o instanceof AcceptAllFilter;
        }

        public int hashCode() {
            return 0;
        }

        public boolean isProperSubset(FeatureFilter sup) {
            return sup.equals(this);
        }

        public boolean isDisjoint(FeatureFilter filt) {
            return filt instanceof AcceptNoneFilter;
        }

        public String toString() {
            return "All";
        }
    }
}

