/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class FastaFormat
implements SequenceFormat,
Serializable {
    public static final String PROPERTY_DESCRIPTIONLINE = "description_line";
    private int lineWidth = 60;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$FastaFormat;

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public boolean readSequence(BufferedReader reader, SymbolParser symParser, SeqIOListener siol) throws IllegalSymbolException, IOException, ParseException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature stream end");
        }
        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        siol.startSequence();
        String description = line.substring(1).trim();
        siol.addSequenceProperty(PROPERTY_DESCRIPTIONLINE, description);
        boolean seenEOF = this.readSequenceData(reader, symParser, siol);
        siol.endSequence();
        return !seenEOF;
    }

    private boolean readSequenceData(BufferedReader r, SymbolParser parser, SeqIOListener listener) throws IOException, IllegalSymbolException {
        char[] cache = new char[256];
        boolean reachedEnd = false;
        boolean seenEOF = false;
        StreamParser sparser = parser.parseStream(listener);
        while (!reachedEnd) {
            r.mark(cache.length);
            int bytesRead = r.read(cache, 0, cache.length);
            if (bytesRead < 0) {
                seenEOF = true;
                reachedEnd = true;
                continue;
            }
            int parseStart = 0;
            int parseEnd = 0;
            while (!reachedEnd && parseStart < bytesRead && cache[parseStart] != '>') {
                parseEnd = parseStart;
                while (parseEnd < bytesRead && cache[parseEnd] != '\n' && cache[parseEnd] != '\r') {
                    ++parseEnd;
                }
                sparser.characters(cache, parseStart, parseEnd - parseStart);
                parseStart = parseEnd + 1;
                while (parseStart < bytesRead && cache[parseStart] == '\n' && cache[parseStart] == '\r') {
                    ++parseStart;
                }
            }
            if (parseStart >= bytesRead || cache[parseStart] != '>') continue;
            r.reset();
            if (r.skip(parseStart) != (long)parseStart) {
                throw new IOException("Couldn't reset to start of next sequence");
            }
            reachedEnd = true;
        }
        sparser.close();
        return seenEOF;
    }

    protected String describeSequence(Sequence seq) {
        String description = null;
        try {
            description = seq.getAnnotation().getProperty(PROPERTY_DESCRIPTIONLINE).toString();
        }
        catch (NoSuchElementException ex) {
            description = seq.getName();
        }
        return description;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        os.print(">");
        os.println(this.describeSequence(seq));
        int pos = 1;
        while (pos <= seq.length() + 1) {
            int end = Math.min(pos + this.lineWidth - 1, seq.length());
            os.println(seq.subStr(pos, end));
            pos += this.lineWidth;
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        String requestedFormat = new String(format);
        boolean found = false;
        String[] formats = this.getFormats().toArray(new String[0]);
        if (!found) {
            throw new IOException("Failed to write: an invalid file format '" + format + "' was requested");
        }
        this.writeSequence(seq, os);
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public String getDefaultFormat() {
        return "Fasta";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashSet<String> validFormats = new HashSet<String>();
        validFormats.add("Fasta");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$FastaFormat == null ? (class$org$biojava$bio$seq$io$FastaFormat = FastaFormat.class$("org.biojava.bio.seq.io.FastaFormat")) : class$org$biojava$bio$seq$io$FastaFormat).getName(), validFormats);
    }
}

