/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class FixedWidthParser
implements SymbolParser,
Serializable {
    private Alphabet alpha;
    private int tokenLength;
    private Map tokenToSymbol = new HashMap();

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public SymbolList parse(String seq) throws IllegalSymbolException {
        SimpleSymbolList sym = new SimpleSymbolList(this.alpha);
        int i = 0;
        while (i < seq.length()) {
            sym.addSymbol(this.parseToken(seq.substring(i, i + this.tokenLength)));
            i += this.tokenLength;
        }
        return sym;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        Symbol sym = (Symbol)this.tokenToSymbol.get(token);
        if (sym == null) {
            throw new IllegalSymbolException("No symbol associated with token " + token);
        }
        return sym;
    }

    public void addTokenMap(String token, Symbol symbol) throws IllegalSymbolException, IllegalArgumentException {
        this.getAlphabet().validate(symbol);
        if (token.length() != this.tokenLength) {
            throw new IllegalArgumentException("token '" + token + "' must be of length " + this.tokenLength);
        }
        this.tokenToSymbol.put(token, symbol);
    }

    public FixedWidthParser(Alphabet alpha, int tokenLength) {
        this.alpha = alpha;
        this.tokenLength = tokenLength;
    }

    public StreamParser parseStream(SeqIOListener l) {
        return new FWStreamParser(l);
    }

    private class FWStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private char[] leftOver;
        private char leftOverLen;
        private Symbol[] buffer = new Symbol[256];

        public FWStreamParser(SeqIOListener l) {
            this.listener = l;
            this.leftOver = new char[FixedWidthParser.this.tokenLength];
            this.leftOverLen = '\u0000';
        }

        /*
         * Unable to fully structure code
         */
        public void characters(char[] data, int pos, int len) throws IllegalSymbolException {
            i = 0;
            bi = 0;
            if (this.leftOverLen > '\u0000') {
                while (this.leftOverLen < FixedWidthParser.access$000(FixedWidthParser.this) && i < len) {
                    v0 = this.leftOverLen;
                    this.leftOverLen = (char)(v0 + '\u0001');
                    this.leftOver[v0] = data[pos + i++];
                }
                if (this.leftOverLen == FixedWidthParser.access$000(FixedWidthParser.this)) {
                    this.buffer[bi++] = FixedWidthParser.this.parseToken(new String(this.leftOver));
                    this.leftOverLen = '\u0000';
                }
            }
            while (len - i >= FixedWidthParser.access$000(FixedWidthParser.this) && bi < this.buffer.length) {
                this.buffer[bi++] = FixedWidthParser.this.parseToken(new String(data, pos + i, FixedWidthParser.access$000(FixedWidthParser.this)));
                i += FixedWidthParser.access$000(FixedWidthParser.this);
            }
            if (bi > 0) {
                try {
                    this.listener.addSymbols(FixedWidthParser.this.getAlphabet(), this.buffer, 0, bi);
                }
                catch (IllegalAlphabetException ex) {
                    throw new BioError(ex);
                }
            }
            if (len - i < FixedWidthParser.access$000(FixedWidthParser.this)) ** GOTO lbl28
            this.characters(data, pos + i, len - i);
            return;
lbl-1000:
            // 1 sources

            {
                v1 = this.leftOverLen;
                this.leftOverLen = (char)(v1 + '\u0001');
                this.leftOver[v1] = data[pos + i++];
lbl28:
                // 2 sources

                ** while (len - i > 0)
            }
lbl29:
            // 1 sources

        }

        public void close() throws IllegalSymbolException {
            if (this.leftOverLen > '\u0000') {
                throw new IllegalSymbolException("FixedWidth stream parser has " + this.leftOverLen + " orphan characters at end of stream");
            }
        }
    }
}

