/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.seq.io.NameParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.seq.io.TokenParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractAlphabet
implements FiniteAlphabet {
    private Map parserByName = new HashMap();
    private ChangeSupport changeSupport;

    protected boolean hasListeners() {
        return this.changeSupport != null;
    }

    protected ChangeSupport getChangeSupport(ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        return this.changeSupport;
    }

    public void putParser(String name, SymbolParser parser) {
        this.parserByName.put(name, parser);
    }

    public SymbolParser getParser(String name) throws NoSuchElementException {
        SymbolParser parser = (SymbolParser)this.parserByName.get(name);
        if (parser == null) {
            if (name.equals("token")) {
                parser = new TokenParser(this);
                this.putParser(name, parser);
            } else if (name.equals("name")) {
                parser = new NameParser(this);
                this.putParser(name, parser);
            } else {
                throw new NoSuchElementException("There is no parser '" + name + "' defined in alphabet " + this.getName());
            }
        }
        return parser;
    }

    public Symbol getAmbiguity(Set syms) throws IllegalSymbolException {
        Iterator i = syms.iterator();
        while (i.hasNext()) {
            this.validate((Symbol)i.next());
        }
        return AlphabetManager.createSymbol('*', Annotation.EMPTY_ANNOTATION, syms, (Alphabet)this);
    }

    public final Symbol getSymbol(List syms) throws IllegalSymbolException {
        if (syms.size() == 1) {
            Symbol s = (Symbol)syms.get(0);
            this.validate(s);
            return s;
        }
        List alphas = this.getAlphabets();
        if (alphas.size() != syms.size()) {
            throw new IllegalSymbolException("Can't retrieve symbol as symbol list is the wrong length " + syms.size() + ":" + alphas.size());
        }
        Iterator si = syms.iterator();
        Iterator ai = this.getAlphabets().iterator();
        int atomic = 0;
        while (si.hasNext()) {
            Symbol s = (Symbol)si.next();
            Alphabet a = (Alphabet)ai.next();
            if (!(s instanceof AtomicSymbol)) continue;
            ++atomic;
        }
        if (atomic == syms.size()) {
            return this.getSymbolImpl(syms);
        }
        return AlphabetManager.createSymbol('*', Annotation.EMPTY_ANNOTATION, syms, (Alphabet)this);
    }

    protected abstract AtomicSymbol getSymbolImpl(List var1) throws IllegalSymbolException;

    protected abstract void addSymbolImpl(AtomicSymbol var1) throws IllegalSymbolException, ChangeVetoException;

    public final void addSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
        if (s == null) {
            throw new IllegalSymbolException("You can not add null as a symbol to alphabet " + this.getName());
        }
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(Alphabet.SYMBOLS);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, Alphabet.SYMBOLS, s, null);
                cs.firePreChangeEvent(ce);
                this.doAddSymbol(s);
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.doAddSymbol(s);
        }
    }

    private void doAddSymbol(Symbol s) throws IllegalSymbolException, ChangeVetoException {
        Alphabet sa = s.getMatches();
        if (!(sa instanceof FiniteAlphabet)) {
            throw new IllegalSymbolException("Can't add symbol " + s.getName() + " as it matches an infinite number of symbols.");
        }
        Iterator si = ((FiniteAlphabet)sa).iterator();
        while (si.hasNext()) {
            this.addSymbolImpl((AtomicSymbol)si.next());
        }
    }

    public final boolean contains(Symbol sym) {
        if (sym instanceof AtomicSymbol) {
            return this.containsImpl((AtomicSymbol)sym);
        }
        if (sym == null) {
            throw new NullPointerException("Symbols can't be null");
        }
        FiniteAlphabet matches = (FiniteAlphabet)sym.getMatches();
        if (matches.size() == 0) {
            if (sym.equals(AlphabetManager.getGapSymbol())) {
                return true;
            }
            if (sym instanceof BasisSymbol && ((BasisSymbol)sym).getSymbols().size() == this.getAlphabets().size()) {
                return true;
            }
            return true;
        }
        Iterator i = matches.iterator();
        while (i.hasNext()) {
            AtomicSymbol s = (AtomicSymbol)i.next();
            if (this.containsImpl(s)) continue;
            return false;
        }
        return true;
    }

    public final Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public final void validate(Symbol sym) throws IllegalSymbolException {
        if (!this.contains(sym)) {
            StringBuffer sb = new StringBuffer("{");
            throw new IllegalSymbolException("Symbol " + sym.getName() + " not found in alphabet " + this.getName() + " " + sb.toString());
        }
    }

    protected abstract boolean containsImpl(AtomicSymbol var1);

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiniteAlphabet)) {
            return false;
        }
        FiniteAlphabet that = (FiniteAlphabet)o;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator i = that.iterator();
        while (i.hasNext()) {
            if (this.contains((AtomicSymbol)i.next())) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener cl) {
        this.getChangeSupport(ChangeType.UNKNOWN).addChangeListener(cl);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.getChangeSupport(ct).addChangeListener(cl, ct);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.getChangeSupport(ChangeType.UNKNOWN).removeChangeListener(cl);
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        this.getChangeSupport(ct).removeChangeListener(cl, ct);
    }

    public String toString() {
        return this.getName();
    }

    protected AbstractAlphabet() {
    }

    public abstract SymbolList symbols();

    public abstract void removeSymbol(Symbol var1) throws IllegalSymbolException, ChangeVetoException;

    public abstract Iterator iterator();

    public abstract int size();

    public abstract List getAlphabets();

    public abstract String getName();

    public abstract Annotation getAnnotation();
}

