/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

public final class LocationTools {
    static /* synthetic */ Class class$org$biojava$bio$symbol$CircularLocation;
    static /* synthetic */ Class class$org$biojava$bio$symbol$BetweenLocation;

    public static Location union(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations();
        }
        if (locA.isContiguous() && locB.isContiguous() && locA.overlaps(locB)) {
            return LocationTools.buildLoc(Math.min(locA.getMin(), locB.getMin()), Math.max(locA.getMax(), locB.getMax()));
        }
        ArrayList locList = new ArrayList();
        Iterator i = locA.blockIterator();
        while (i.hasNext()) {
            locList.add(i.next());
        }
        Iterator i2 = locB.blockIterator();
        while (i2.hasNext()) {
            locList.add(i2.next());
        }
        return LocationTools._union(locList);
    }

    public static Location intersection(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations();
        }
        if (locA.isContiguous() && locB.isContiguous()) {
            if (locA.overlaps(locB)) {
                int min = Math.max(locA.getMin(), locB.getMin());
                int max = Math.min(locA.getMax(), locB.getMax());
                return LocationTools.buildLoc(min, max);
            }
            return Location.empty;
        }
        ArrayList<Location> locList = new ArrayList<Location>();
        Iterator aI = locA.blockIterator();
        while (aI.hasNext()) {
            Location a = (Location)aI.next();
            Iterator bI = locB.blockIterator();
            while (bI.hasNext()) {
                Location b = (Location)bI.next();
                Location bIn = LocationTools.intersection(a, b);
                if (bIn == Location.empty) continue;
                locList.add(bIn);
            }
        }
        return LocationTools.buildLoc(locList);
    }

    public static boolean overlaps(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations();
        }
        if (locA.isContiguous() && locB.isContiguous()) {
            return locA.getMax() >= locB.getMin() && locA.getMin() <= locB.getMax();
        }
        Iterator aI = locA.blockIterator();
        while (aI.hasNext()) {
            Location a = (Location)aI.next();
            Iterator bI = locB.blockIterator();
            while (bI.hasNext()) {
                Location b = (Location)bI.next();
                if (!LocationTools.overlaps(a, b)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations();
        }
        if (locA.isContiguous() && locB.isContiguous()) {
            return locA.getMin() <= locB.getMin() && locA.getMax() >= locB.getMax();
        }
        Iterator bI = locB.blockIterator();
        block0: while (bI.hasNext()) {
            Location b = (Location)bI.next();
            Iterator aI = locA.blockIterator();
            while (aI.hasNext()) {
                Location a = (Location)aI.next();
                if (LocationTools.contains(a, b)) continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean areEqual(Location locA, Location locB) {
        if (LocationTools.isDecorated(locA) || LocationTools.isDecorated(locB)) {
            LocationTools.handleDecorations();
        }
        if (locA.isContiguous() != locB.isContiguous()) {
            return false;
        }
        if (locA.isContiguous()) {
            return locA.getMin() == locB.getMin() && locA.getMax() == locB.getMax();
        }
        Iterator i1 = locA.blockIterator();
        Iterator i2 = locB.blockIterator();
        while (i1.hasNext() && i2.hasNext()) {
            Location l1 = (Location)i1.next();
            Location l2 = (Location)i2.next();
            if (l1.getMin() == l2.getMin() && l1.getMax() == l2.getMax()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    static Location buildLoc(List locList) {
        Collections.sort(locList, Location.naturalOrder);
        if (locList.size() == 0) {
            return Location.empty;
        }
        if (locList.size() == 1) {
            return (Location)locList.get(0);
        }
        return new CompoundLocation(locList);
    }

    public static Location union(Collection locs) {
        ArrayList locList = new ArrayList();
        Iterator li = locs.iterator();
        while (li.hasNext()) {
            Location loc = (Location)li.next();
            Iterator bi = loc.blockIterator();
            while (bi.hasNext()) {
                locList.add(bi.next());
            }
        }
        return LocationTools._union(locList);
    }

    private static Location _union(List locList) {
        Collections.sort(locList, Location.naturalOrder);
        ArrayList<Location> joinList = new ArrayList<Location>();
        Iterator i = locList.iterator();
        Location last = Location.empty;
        if (i.hasNext()) {
            last = (Location)i.next();
        }
        while (i.hasNext()) {
            Location cur = (Location)i.next();
            if (last.overlaps(cur)) {
                int min = Math.min(last.getMin(), cur.getMin());
                int max = Math.max(last.getMax(), cur.getMax());
                last = LocationTools.buildLoc(min, max);
                continue;
            }
            joinList.add(last);
            last = cur;
        }
        if (last == Location.empty) {
            return Location.empty;
        }
        joinList.add(last);
        return LocationTools.buildLoc(joinList);
    }

    protected static Location buildLoc(int min, int max) {
        if (min == max) {
            return new PointLocation(min);
        }
        return new RangeLocation(min, max);
    }

    protected static boolean isDecorated(Location theLocation) {
        boolean hasCircular = theLocation.getDecorator(class$org$biojava$bio$symbol$CircularLocation == null ? (class$org$biojava$bio$symbol$CircularLocation = LocationTools.class$("org.biojava.bio.symbol.CircularLocation")) : class$org$biojava$bio$symbol$CircularLocation) != null;
        boolean hasBetween = theLocation.getDecorator(class$org$biojava$bio$symbol$BetweenLocation == null ? (class$org$biojava$bio$symbol$BetweenLocation = LocationTools.class$("org.biojava.bio.symbol.BetweenLocation")) : class$org$biojava$bio$symbol$BetweenLocation) != null;
        return hasCircular || hasBetween;
    }

    protected static void handleDecorations() {
        throw new ClassCastException("Decorated locations are not handled in this version");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

