/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.symbol.AbstractLocation;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class PointLocation
extends AbstractLocation
implements Location,
Serializable {
    private int point;

    public int getMin() {
        return this.point;
    }

    public int getMax() {
        return this.point;
    }

    public boolean contains(int p) {
        return this.point == p;
    }

    public SymbolList symbols(SymbolList s) {
        final Symbol sym = s.symbolAt(this.point);
        try {
            return new SimpleSymbolList(s.getAlphabet(), new AbstractList(){

                public Object get(int index) throws IndexOutOfBoundsException {
                    if (index == 0) {
                        return sym;
                    }
                    throw new IndexOutOfBoundsException("Index " + index + " greater than 0");
                }

                public int size() {
                    return 1;
                }
            });
        }
        catch (IllegalSymbolException ex) {
            throw new BioError(ex);
        }
    }

    public boolean isContiguous() {
        return true;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public Location translate(int dist) {
        if (dist == 0) {
            return this;
        }
        return new PointLocation(this.point + dist);
    }

    public PointLocation(int point) {
        this.point = point;
    }

    public String toString() {
        return String.valueOf(this.point);
    }
}

