/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

public class ParserException
extends Exception {
    private String locator = null;
    private int lineNumber = -1;
    private int character = -1;
    private String line = null;

    public ParserException(String detail) {
        super(detail);
    }

    public ParserException(String detail, String locator) {
        super(detail);
        this.locator = locator;
    }

    public ParserException(String detail, String locator, int line) {
        super(detail);
        this.locator = locator;
        this.lineNumber = line;
    }

    public ParserException(String detail, String locator, int lineNumber, String line) {
        super(detail);
        this.locator = locator;
        this.lineNumber = lineNumber;
        this.line = line;
    }

    public ParserException(String detail, String locator, int lineNumber, String line, int character) {
        super(detail);
        this.locator = locator;
        this.lineNumber = lineNumber;
        this.character = character;
        this.line = line;
    }

    public String getLocator() {
        return this.locator;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharacterOffset() {
        return this.character;
    }

    public String getLine() {
        return this.line;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        if (this.locator != null) {
            sb.append('\n');
            sb.append("Parsing location: ");
            sb.append(this.locator);
        }
        if (this.lineNumber >= 0) {
            sb.append('\n');
            sb.append("Parsing line: ");
            sb.append(this.lineNumber);
        }
        if (this.line != null) {
            sb.append('\n');
            sb.append(this.line);
            if (this.character >= 0) {
                sb.append('\n');
                int i = 0;
                while (i < this.character) {
                    sb.append(' ');
                    ++i;
                }
                sb.append('^');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

