/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import java.util.Arrays;
import java.util.List;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.EmissionCache;
import org.biojava.bio.dp.twohead.PairDPCursor;
import org.biojava.bio.dp.twohead.PairDPMatrix;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public abstract class AbstractMatrixPairDPCursor
implements PairDPCursor {
    protected int[] pos;
    protected SymbolList[] seqs;
    protected double[][][] columns;
    protected BackPointer[][][] bPointers;
    protected double[][][] emissions;
    protected int numStates;
    protected double[] zeroCol;
    protected BackPointer[] emptyBP;
    protected int[] depth;
    protected double[][][] sMatrix;
    protected EmissionCache eCache;

    public AbstractMatrixPairDPCursor(SymbolList seq1, SymbolList seq2, int start1, int start2, int depth1, int depth2, PairDPMatrix matrix, EmissionCache eCache) throws IllegalSymbolException {
        this.numStates = matrix.states().length;
        this.zeroCol = new double[this.numStates];
        int i = 0;
        while (i < this.zeroCol.length) {
            this.zeroCol[i] = Double.NaN;
            ++i;
        }
        this.emptyBP = new BackPointer[this.numStates];
        this.sMatrix = matrix.getScoreArray();
        this.pos = new int[2];
        this.pos[0] = start1;
        this.pos[1] = start2;
        this.seqs = new SymbolList[2];
        this.seqs[0] = seq1;
        this.seqs[1] = seq2;
        this.depth = new int[2];
        this.depth[0] = depth1;
        this.depth[1] = depth2;
        this.bPointers = new BackPointer[seq1.length() + 2][seq2.length() + 2][this.numStates];
        this.emissions = new double[seq1.length() + 2][seq2.length() + 2][];
        this.eCache = eCache;
        Symbol[] symArray = new Symbol[2];
        List<Symbol> symList = Arrays.asList(symArray);
        int i2 = 0;
        while (i2 <= seq1.length() + 1) {
            symArray[0] = i2 < 1 || i2 > seq1.length() ? AlphabetManager.getGapSymbol() : seq1.symbolAt(i2);
            double[][] ei = this.emissions[i2];
            int j = 0;
            while (j <= seq2.length() + 1) {
                symArray[1] = j < 1 || j > seq2.length() ? AlphabetManager.getGapSymbol() : seq2.symbolAt(j);
                ei[j] = eCache.getEmissions(symList);
                ++j;
            }
            ++i2;
        }
    }

    public int[] getDepth() {
        return this.depth;
    }

    public Cell[][] press() {
        Cell[][] cells = new Cell[this.depth[0]][this.depth[1]];
        int i = 0;
        while (i < cells.length) {
            Cell[] ci = cells[i];
            int j = 0;
            while (j < ci.length) {
                ci[j] = new Cell();
                ++j;
            }
            ++i;
        }
        return cells;
    }

    public abstract void next(Cell[][] var1) throws IllegalSymbolException;

    public abstract boolean hasNext();
}

