/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

class DASComponentFeature
implements ComponentFeature {
    private final DASSequence parent;
    private FeatureHolder projectedFeatures;
    private final Location location;
    private final StrandedFeature.Strand strand;
    private final String type;
    private final String source;
    private final Annotation annotation;
    private final String componentID;
    private DASSequence componentSequence;
    private Location componentLocation;
    private final FeatureFilter membershipFilter;

    public DASComponentFeature(DASSequence parent, ComponentFeature.Template temp) throws BioException {
        if (this.locationContent(temp.location) != this.locationContent(temp.componentLocation)) {
            throw new BioException("Component and container locations must contain an equal number of symbols.");
        }
        if (!temp.location.isContiguous() || !temp.componentLocation.isContiguous()) {
            throw new BioException("Can only include contiguous segments in an assembly");
        }
        this.parent = parent;
        this.location = temp.location;
        this.componentLocation = temp.componentLocation;
        this.strand = temp.strand;
        this.type = temp.type;
        this.source = temp.source;
        this.annotation = temp.annotation;
        this.membershipFilter = new FeatureFilter.ContainedByLocation(this.location);
        if (temp.componentSequence != null) {
            this.componentSequence = (DASSequence)temp.componentSequence;
            this.componentID = this.componentSequence.getName();
        } else {
            try {
                this.componentID = (String)temp.annotation.getProperty("sequence.id");
            }
            catch (NoSuchElementException ex) {
                throw new BioError("No sequence.id property");
            }
        }
        if (this.strand != StrandedFeature.NEGATIVE && this.strand != StrandedFeature.POSITIVE) {
            throw new BioException("Strand must be specified when creating a ComponentFeature");
        }
    }

    private int locationContent(Location l) {
        if (l.isContiguous()) {
            return l.getMax() - l.getMin() + 1;
        }
        int content = 0;
        Iterator i = l.blockIterator();
        while (i.hasNext()) {
            Location sl = (Location)i.next();
            content += sl.getMax() - sl.getMin() + 1;
        }
        return content;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public SymbolList getSymbols() {
        SymbolList syms = this.componentLocation.symbols(this.getComponentSequence());
        if (this.strand == StrandedFeature.NEGATIVE) {
            try {
                syms = DNATools.reverseComplement(syms);
            }
            catch (IllegalAlphabetException ex) {
                throw new BioError(ex);
            }
        }
        return syms;
    }

    DASSequence getSequenceLazy() {
        return this.componentSequence;
    }

    public Sequence getComponentSequence() {
        if (this.componentSequence == null) {
            try {
                this.componentSequence = this.parent.getParentDB()._getSequence(this.componentID, this.parent.dataSourceURLs());
            }
            catch (Exception ex) {
                throw new BioError(ex, "Couldn't create child DAS sequence");
            }
        }
        return this.componentSequence;
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            if (this.strand == StrandedFeature.NEGATIVE) {
                int translation = this.location.getMax() + this.componentLocation.getMin();
                this.projectedFeatures = new ProjectedFeatureHolder(this.getComponentSequence(), this, translation, true);
            } else if (this.strand == StrandedFeature.POSITIVE) {
                int translation = this.location.getMin() - this.componentLocation.getMin();
                this.projectedFeatures = new ProjectedFeatureHolder(this.getComponentSequence(), this, translation, false);
            }
        }
        return this.projectedFeatures;
    }

    public int countFeatures() {
        return this.getComponentSequence().countFeatures();
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public boolean containsFeature(Feature f) {
        return this.getProjectedFeatures().containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        if (FilterUtils.areDisjoint(ff, this.membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(ff, recurse);
    }

    public Feature createFeature(Feature.Template temp) throws BioException {
        throw new BioException("Can't create features in a ComponentFeature (yet?)");
    }

    public void removeFeature(Feature f) {
        throw new UnsupportedOperationException("Can't remove features from a ComponentFeature.");
    }

    public Feature.Template makeTemplate() {
        throw new BioError("FIXME");
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }
}

