/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.phred;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.phred.PhredSequence;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.GappedSymbolList;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

public class GappedPhredSequence
extends PhredSequence {
    private GappedSymbolList seq;
    private GappedSymbolList qual;

    public GappedPhredSequence(GappedSymbolList sequence, GappedSymbolList quality, String name, String urn, Annotation anno) throws BioException {
        super((SymbolList)sequence, quality, name, urn, anno);
        this.seq = sequence;
        this.qual = quality;
        if (this.badIntegrity()) {
            throw new BioException("Sequence and Quality information differ in Length and/or Gap position");
        }
    }

    public GappedPhredSequence(SymbolList sequence, SymbolList quality, String name, String urn, Annotation anno) throws BioException {
        this(new GappedSymbolList(sequence), new GappedSymbolList(quality), name, urn, anno);
    }

    public synchronized void addGapInSource(int pos) {
        this.seq.addGapInSource(pos);
        this.qual.addGapInSource(pos);
    }

    public synchronized void addGapInView(int pos) {
        this.seq.addGapInView(pos);
        this.qual.addGapInView(pos);
    }

    public synchronized void addGapsinView(int pos, int length) {
        this.seq.addGapsInView(pos, length);
        this.qual.addGapsInView(pos, length);
    }

    public synchronized void addGapsinSource(int pos, int length) {
        this.seq.addGapsInSource(pos, length);
        this.qual.addGapsInSource(pos, length);
    }

    private synchronized boolean badIntegrity() {
        if (this.seq.length() != this.qual.length()) {
            return true;
        }
        return !this.gapPositions(this.seq).equals(this.gapPositions(this.qual));
    }

    public synchronized int firstNonGap() {
        int y;
        int x = this.seq.firstNonGap();
        if (x == (y = this.qual.firstNonGap())) {
            return x;
        }
        throw new BioError("Sequence and Quality Information are not Equally Gapped");
    }

    private synchronized List gapPositions(GappedSymbolList s) {
        ArrayList<Integer> gapPos = new ArrayList<Integer>();
        int i = 1;
        while (i <= s.length()) {
            if (s.symbolAt(i).equals(s.getAlphabet().getGapSymbol())) {
                gapPos.add(new Integer(i));
            }
            ++i;
        }
        return gapPos;
    }

    public Alphabet getSequenceAlphabet() {
        return this.seq.getAlphabet();
    }

    public Alphabet getQualityAlphabet() {
        return this.qual.getAlphabet();
    }

    public synchronized int lastNonGap() {
        int y;
        int x = this.seq.lastNonGap();
        if (x == (y = this.qual.lastNonGap())) {
            return x;
        }
        throw new BioError("Sequence and Quality Information are not Equally Gapped");
    }

    public synchronized int length() {
        int y;
        int x = this.seq.length();
        if (x == (y = this.qual.length())) {
            return x;
        }
        throw new BioError("Sequence and Quality Information are not Equally in Length");
    }

    public synchronized void removeGap(int pos) throws IndexOutOfBoundsException, IllegalSymbolException {
        this.seq.removeGap(pos);
        this.qual.removeGap(pos);
    }

    public synchronized void removeGaps(int pos, int length) throws IndexOutOfBoundsException, IllegalSymbolException {
        this.seq.removeGaps(pos, length);
        this.qual.removeGaps(pos, length);
    }

    public synchronized int sourceToView(int index) {
        int y;
        int x = this.seq.sourceToView(index);
        if (x == (y = this.qual.sourceToView(index))) {
            return x;
        }
        throw new BioError("Sequence and Quality Information are not Equally Gapped");
    }

    public Symbol seqSymbolAt(int index) {
        return this.seq.symbolAt(index);
    }

    public Symbol qualSymbolAt(int index) {
        return this.qual.symbolAt(index);
    }

    public synchronized int viewToSource(int index) {
        int y;
        int x = this.seq.viewToSource(index);
        if (x == (y = this.qual.viewToSource(index))) {
            return x;
        }
        throw new BioError("Sequence and Quality Information are not Equally Gapped");
    }
}

