/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PdbSAXParser
extends AbstractNativeAppSAXParser {
    private ArrayList oRecordList = new ArrayList();
    private String oRecord;
    private int iPos;
    private int iModelStart;
    private int iModelStop;
    private AttributesImpl oAtts = new AttributesImpl();
    private ArrayList oHeader = new ArrayList();
    private QName oAttQName = new QName(this);

    public PdbSAXParser() {
        this.setNamespacePrefix("biojava");
    }

    public void parse(InputSource poSource) throws IOException, SAXException {
        String oLine = null;
        BufferedReader oContents = this.getContentStream(poSource);
        try {
            oLine = oContents.readLine();
            while (oLine != null) {
                this.oRecordList.add(oLine);
                oLine = oContents.readLine();
            }
            boolean tIsModel = false;
            int i = 0;
            while (i < this.oRecordList.size()) {
                this.oRecord = (String)this.oRecordList.get(i);
                if (this.oRecord.startsWith("MODEL")) {
                    tIsModel = true;
                    break;
                }
                ++i;
            }
            boolean tFoundFirstAtom = false;
            if (!tIsModel) {
                int i2 = 0;
                while (i2 < this.oRecordList.size()) {
                    this.oRecord = (String)this.oRecordList.get(i2);
                    if (this.oRecord.startsWith("ATOM  ") && !tFoundFirstAtom) {
                        tFoundFirstAtom = true;
                        this.oRecordList.add(i2, "MODEL        1");
                        break;
                    }
                    ++i2;
                }
                boolean tFoundLastAtom = false;
                int i3 = this.oRecordList.size() - 1;
                while (i3 > 0) {
                    this.oRecord = (String)this.oRecordList.get(i3);
                    if ((this.oRecord.startsWith("ATOM  ") || this.oRecord.startsWith("HETATM") || this.oRecord.startsWith("TER")) && !tFoundLastAtom) {
                        tFoundLastAtom = true;
                        this.oRecordList.add(i3 + 1, "ENDMDL");
                        break;
                    }
                    --i3;
                }
            }
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("MacromolecularStructure")), this.oAtts);
            this.iPos = 0;
            this.iModelStart = 0;
            this.iModelStop = 0;
            while (this.iPos < this.oRecordList.size()) {
                this.oRecord = (String)this.oRecordList.get(this.iPos);
                if (this.oRecord.startsWith("MODEL")) {
                    this.iModelStart = this.iPos;
                    String oModelId = this.oRecord.substring(10, 14).trim();
                    this.oAtts.clear();
                    this.oAttQName.setQName("modelId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oModelId);
                    this.startElement(new QName(this, this.prefix("Model")), this.oAtts);
                }
                if (this.oRecord.startsWith("ENDMDL")) {
                    this.iModelStop = this.iPos;
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("Protein")), this.oAtts);
                    this.oAtts.clear();
                    this.startElement(new QName(this, this.prefix("ProteinChainList")), this.oAtts);
                    this.parseProtein(this.iModelStart, this.iModelStop);
                    this.endElement(new QName(this, this.prefix("Atom")));
                    this.endElement(new QName(this, this.prefix("Residue")));
                    this.endElement(new QName(this, this.prefix("ProteinChain")));
                    this.endElement(new QName(this, this.prefix("ProteinChainList")));
                    this.endElement(new QName(this, this.prefix("Model")));
                }
                ++this.iPos;
            }
            this.endElement(new QName(this, this.prefix("MacromolecularStructure")));
        }
        catch (IOException x) {
            System.out.println(x.getMessage());
            System.out.println("File read interupted");
        }
    }

    private void parseProtein(int piStart, int piStop) throws SAXException {
        boolean tFirstChain = true;
        boolean tFirstResidue = true;
        String oCurrentChainId = "XXX";
        String oCurrentResidueId = "A*ZZ**";
        int i = piStart;
        while (i < piStop) {
            this.oRecord = (String)this.oRecordList.get(i);
            if (this.oRecord.startsWith("ATOM  ")) {
                String oAtomId = this.oRecord.substring(6, 11).trim();
                String oAtomType = this.oRecord.substring(12, 16).trim();
                String oResidueType = this.oRecord.substring(17, 20).trim();
                if (this.checkIfProtein(oResidueType)) {
                    String oChainId = this.oRecord.substring(21, 23).trim();
                    String oResidueId = this.oRecord.substring(23, 27).trim();
                    String oX = this.oRecord.substring(30, 38).trim();
                    String oY = this.oRecord.substring(38, 46).trim();
                    String oZ = this.oRecord.substring(47, 53).trim();
                    if (!oResidueId.equals(oCurrentResidueId)) {
                        if (!tFirstResidue) {
                            this.endElement(new QName(this, this.prefix("Residue")));
                        }
                        if (!oChainId.equals(oCurrentChainId)) {
                            if (!tFirstChain) {
                                this.endElement(new QName(this, this.prefix("ProteinChain")));
                            }
                            this.oAtts.clear();
                            this.oAttQName.setQName("chainId");
                            this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oChainId);
                            this.startElement(new QName(this, this.prefix("ProteinChain")), this.oAtts);
                            tFirstChain = false;
                            oCurrentChainId = oChainId;
                        }
                        this.oAtts.clear();
                        this.oAttQName.setQName("residueId");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oResidueId);
                        this.oAttQName.setQName("residueType");
                        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oResidueType);
                        this.startElement(new QName(this, this.prefix("Residue")), this.oAtts);
                        tFirstResidue = false;
                        oCurrentResidueId = oResidueId;
                    }
                    this.oAtts.clear();
                    this.oAttQName.setQName("atomId");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oAtomId);
                    this.oAttQName.setQName("atomType");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oAtomType);
                    this.startElement(new QName(this, this.prefix("Atom")), this.oAtts);
                    this.oAtts.clear();
                    this.oAttQName.setQName("x");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oX);
                    this.oAttQName.setQName("y");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oY);
                    this.oAttQName.setQName("z");
                    this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", oZ);
                    this.startElement(new QName(this, this.prefix("Coordinates")), this.oAtts);
                    this.endElement(new QName(this, this.prefix("Coordinates")));
                    this.endElement(new QName(this, this.prefix("Atom")));
                }
            }
            ++i;
        }
    }

    private void parseAtomRecord(String poRecord) {
        System.out.println(poRecord);
        String oChainId = poRecord.substring(21, 23);
        String oResidueId = poRecord.substring(23, 27);
        oChainId = oChainId.trim();
        oResidueId = oResidueId.trim();
        System.out.println("ChainId>" + oChainId + "<");
    }

    private boolean checkIfProtein(String poResType) {
        return true;
    }
}

