/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.search.SeqSimilaritySearchResult;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ObjectUtil;
import org.biojava.utils.contract.Contract;

public class SequenceDBSearchResult
extends AbstractChangeable
implements SeqSimilaritySearchResult,
Annotatable {
    private SequenceDB sequenceDB;
    private Map searchParameters;
    private SymbolList querySeq;
    private List hits;
    private Annotation annotation;

    public SequenceDBSearchResult(SequenceDB sequenceDB, Map searchParameters, SymbolList querySeq, Annotation annotation, List hits) {
        Contract.pre(querySeq != null, "querySeq was null");
        Contract.pre(sequenceDB != null, "sequenceDB was null");
        Contract.pre(annotation != null, "annotation was null");
        Contract.pre(hits != null, "hits was null");
        this.sequenceDB = sequenceDB;
        this.searchParameters = searchParameters;
        this.querySeq = querySeq;
        this.hits = hits;
        this.annotation = annotation;
        this.sequenceDB.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.querySeq.addChangeListener(ChangeListener.ALWAYS_VETO);
        this.annotation.addChangeListener(ChangeListener.ALWAYS_VETO);
    }

    public SymbolList getQuerySequence() {
        return this.querySeq;
    }

    public SequenceDB getSequenceDB() {
        return this.sequenceDB;
    }

    public Map getSearchParameters() {
        return this.searchParameters == null ? null : Collections.unmodifiableMap(this.searchParameters);
    }

    public List getHits() {
        return Collections.unmodifiableList(this.hits);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SequenceDBSearchResult that = (SequenceDBSearchResult)other;
        if (!ObjectUtil.equals(this.querySeq, that.querySeq)) {
            return false;
        }
        if (!ObjectUtil.equals(this.sequenceDB, that.sequenceDB)) {
            return false;
        }
        if (!ObjectUtil.equals(this.searchParameters, that.searchParameters)) {
            return false;
        }
        if (!ObjectUtil.equals(this.hits, that.hits)) {
            return false;
        }
        return ObjectUtil.equals(this.annotation, that.annotation);
    }

    public int hashCode() {
        int hc = 0;
        hc = ObjectUtil.hashCode(hc, this.querySeq);
        hc = ObjectUtil.hashCode(hc, this.sequenceDB);
        hc = ObjectUtil.hashCode(hc, this.searchParameters);
        hc = ObjectUtil.hashCode(hc, this.hits);
        hc = ObjectUtil.hashCode(hc, this.annotation);
        return hc;
    }

    public String toString() {
        return "SequenceDBSearchResult of " + this.getQuerySequence() + " against " + this.getSequenceDB();
    }
}

