/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

public class CharacterTokenization
implements SymbolTokenization {
    private Alphabet alphabet;
    private Map symbolsToCharacters = new HashMap();
    private transient Symbol[] tokenTable;

    public CharacterTokenization(Alphabet alpha) {
        this.alphabet = alpha;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public SymbolTokenization.TokenType getTokenType() {
        return SymbolTokenization.CHARACTER;
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public void bindSymbol(Symbol s, char c) {
        this.symbolsToCharacters.put(s, new Character(c));
        this.tokenTable = null;
    }

    public Symbol parseToken(String token) throws IllegalSymbolException {
        if (token.length() != 1) {
            throw new IllegalSymbolException("This Tokenization only accepts single-character tokens");
        }
        return this.parseTokenChar(token.charAt(0));
    }

    protected Symbol[] getTokenTable() {
        if (this.tokenTable == null) {
            int maxChar = 0;
            Iterator i = this.symbolsToCharacters.values().iterator();
            while (i.hasNext()) {
                Character c = (Character)i.next();
                maxChar = Math.max(maxChar, c.charValue());
            }
            this.tokenTable = new Symbol[maxChar + 1];
            Iterator i2 = this.symbolsToCharacters.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry me = i2.next();
                Symbol sym = (Symbol)me.getKey();
                Character c = (Character)me.getValue();
                this.tokenTable[c.charValue()] = sym;
            }
        }
        return this.tokenTable;
    }

    protected Symbol parseTokenChar(char c) throws IllegalSymbolException {
        Symbol[] tokenTable = this.getTokenTable();
        Symbol sym = null;
        if (c < tokenTable.length) {
            sym = tokenTable[c];
        }
        if (sym == null) {
            throw new IllegalSymbolException("This tokenization doesn't contain character: " + c);
        }
        return sym;
    }

    public String tokenizeSymbol(Symbol s) throws IllegalSymbolException {
        Character c = (Character)this.symbolsToCharacters.get(s);
        if (c == null) {
            throw new IllegalSymbolException("No mapping for symbol " + s.getName());
        }
        return "" + c.charValue();
    }

    public String tokenizeSymbolList(SymbolList sl) throws IllegalAlphabetException {
        if (sl.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Alphabet " + sl.getAlphabet().getName() + " does not match " + this.getAlphabet().getName());
        }
        StringBuffer sb = new StringBuffer();
        Iterator i = sl.iterator();
        while (i.hasNext()) {
            Symbol sym = (Symbol)i.next();
            Character c = (Character)this.symbolsToCharacters.get(sym);
            if (c == null) {
                throw new IllegalAlphabetException("No mapping for symbol " + sym.getName());
            }
            sb.append(c.charValue());
        }
        return sb.toString();
    }

    public StreamParser parseStream(SeqIOListener listener) {
        return new TPStreamParser(listener);
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    private class TPStreamParser
    implements StreamParser {
        private SeqIOListener listener;
        private Symbol[] buffer = new Symbol[256];

        public TPStreamParser(SeqIOListener l) {
            this.listener = l;
        }

        public void characters(char[] data, int start, int len) throws IllegalSymbolException {
            int cnt = 0;
            while (cnt < len) {
                int bcnt = 0;
                while (cnt < len && bcnt < this.buffer.length) {
                    this.buffer[bcnt++] = CharacterTokenization.this.parseTokenChar(data[start + cnt++]);
                }
                try {
                    this.listener.addSymbols(CharacterTokenization.this.getAlphabet(), this.buffer, 0, bcnt);
                }
                catch (IllegalAlphabetException ex) {
                    throw new BioError(ex, "Assertion failed: can't add symbols.");
                }
            }
        }

        public void close() {
        }
    }
}

