/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.GenbankContext;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class GenbankFormat
implements SequenceFormat,
Serializable {
    protected static final String END_SEQUENCE_TAG = "//";
    protected static final String FEATURE_TAG = "FEATURES";
    protected static final String START_SEQUENCE_TAG = "ORIGIN";
    protected static final String FEATURE_LINE_PREFIX = "     ";
    protected static final String FEATURE_FLAG = "FT";
    protected static final String ACCESSION_TAG = "ACCESSION";
    protected static final String LOCUS_TAG = "LOCUS";
    protected static final String SIZE_TAG = "SIZE";
    protected static final String TYPE_TAG = "TYPE";
    protected static final String STRAND_NUMBER_TAG = "STRANDS";
    protected static final String CIRCULAR_TAG = "CIRCULAR";
    protected static final String DIVISION_TAG = "DIVISION";
    protected static final String DATE_TAG = "MDAT";
    protected static final String VERSION_TAG = "VERSION";
    protected static final String GI_TAG = "GI";
    static /* synthetic */ Class class$org$biojava$bio$seq$io$GenbankFormat;

    /*
     * WARNING - void declaration
     */
    public boolean readSequence(BufferedReader reader, SymbolParser symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        String line;
        GenbankContext ctx = new GenbankContext(symParser, listener);
        boolean hasAnotherSequence = true;
        boolean hasInternalWhitespace = false;
        listener.startSequence();
        while ((line = reader.readLine()) != null) {
            void var5_7;
            if (var5_7.startsWith(END_SEQUENCE_TAG)) {
                block5: {
                    ctx.processLine((String)var5_7);
                    char[] cbuf = new char[1];
                    while (true) {
                        reader.mark(1);
                        if (reader.read() == -1) {
                            hasAnotherSequence = false;
                            break block5;
                        }
                        reader.read(cbuf, 0, 1);
                        if (!Character.isWhitespace(cbuf[0])) break;
                        hasInternalWhitespace = true;
                    }
                    if (hasInternalWhitespace) {
                        System.err.println("Warning: whitespace found between sequence entries");
                    }
                    reader.reset();
                }
                listener.endSequence();
                return hasAnotherSequence;
            }
            ctx.processLine((String)var5_7);
        }
        throw new IOException("Premature end of stream for GENBANK");
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        String defaultFormat = this.getDefaultFormat();
        try {
            SeqFileFormer former = SeqFileFormerFactory.makeFormer(defaultFormat);
            former.setPrintStream(os);
            SeqIOEventEmitter.getSeqIOEvents(seq, former);
        }
        catch (BioException bex) {
            throw new IOException(bex.getMessage());
        }
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        String requestedFormat = new String(format);
        boolean found = false;
        String[] formats = this.getFormats().toArray(new String[0]);
        int i = 0;
        while (i < formats.length) {
            if (formats[i].equalsIgnoreCase(format)) {
                requestedFormat = formats[i];
                found = true;
            }
            ++i;
        }
        if (!found) {
            throw new IOException("Failed to write: an invalid file format '" + format + "' was requested");
        }
        try {
            SeqFileFormer former = SeqFileFormerFactory.makeFormer(requestedFormat);
            former.setPrintStream(os);
            SeqIOEventEmitter.getSeqIOEvents(seq, former);
        }
        catch (BioException be) {
            throw new IOException(be.getMessage());
        }
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    public String getDefaultFormat() {
        return "Genbank";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HashSet<String> validFormats = new HashSet<String>();
        validFormats.add("Genbank");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$GenbankFormat == null ? (class$org$biojava$bio$seq$io$GenbankFormat = GenbankFormat.class$("org.biojava.bio.seq.io.GenbankFormat")) : class$org$biojava$bio$seq$io$GenbankFormat).getName(), validFormats);
    }
}

