/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

class SubArraySymbolList
extends AbstractSymbolList {
    private final Alphabet alpha;
    private final int length;
    private final int offset;
    private final Symbol[] array;

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    SubArraySymbolList(Symbol[] array, int length, int offset, Alphabet alpha) {
        this.alpha = alpha;
        this.length = length;
        this.offset = offset;
        this.array = array;
        if (length + offset > array.length) {
            throw new IndexOutOfBoundsException();
        }
        alpha.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int pos) {
        if (pos < 1 || pos > this.length) {
            throw new IndexOutOfBoundsException("Index out of range: " + pos);
        }
        return this.array[this.offset + pos - 1];
    }
}

