/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.bio.symbol.Symbol;

public class SwissprotFileFormer
implements SeqFileFormer {
    static int LOCATION_WIDTH = 6;
    PrintStream mStream;

    private SwissprotFileFormer(PrintStream theStream) {
        this.mStream = theStream;
    }

    public void startSequence() throws ParseException {
    }

    public void endSequence() throws ParseException {
    }

    public void setName(String theName) throws ParseException {
    }

    public void setURI(String theURI) throws ParseException {
    }

    public void addSymbols(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        this.printOutSequenceHeaderLine(theAlphabet, theSymbols, theStart, theLength);
        String newLine = System.getProperty("line.separator");
        List brokenLines = this.breakSymbolArray(theAlphabet, theSymbols, theStart, theLength);
        Iterator iterator = brokenLines.iterator();
        String leader = "     ";
        while (iterator.hasNext()) {
            this.getPrintStream().print(leader + iterator.next() + newLine);
        }
        this.getPrintStream().println("//");
    }

    public void addSequenceProperty(Object theKey, Object theValue) throws ParseException {
    }

    public void startFeature(Feature.Template theTemplate) throws ParseException {
    }

    public void endFeature() throws ParseException {
    }

    public void addFeatureProperty(Object theKey, Object theValue) throws ParseException {
    }

    public PrintStream getPrintStream() {
        return this.mStream;
    }

    public void setPrintStream(PrintStream theStream) {
        this.mStream = theStream;
    }

    public StringBuffer formatLocation(StringBuffer theBuffer, Location theLocation, StrandedFeature.Strand theStrand) {
        return this.formatLocation(theBuffer, theLocation);
    }

    public StringBuffer formatLocation(StringBuffer theBuffer, Location theLocation) {
        StringBuffer startPoint = new StringBuffer(LOCATION_WIDTH);
        StringBuffer endPoint = new StringBuffer(LOCATION_WIDTH);
        if (theLocation instanceof PointLocation || theLocation instanceof RangeLocation) {
            startPoint = this.formatPoint(theLocation.getMin(), theLocation.getMin(), false);
            endPoint = this.formatPoint(theLocation.getMax(), theLocation.getMax(), false);
        } else if (theLocation instanceof FuzzyLocation) {
            FuzzyLocation tempLocation = (FuzzyLocation)theLocation;
            startPoint = this.formatPoint(tempLocation.getOuterMin(), tempLocation.getInnerMin(), tempLocation.isMinFuzzy());
            endPoint = this.formatPoint(tempLocation.getInnerMax(), tempLocation.getOuterMax(), tempLocation.isMaxFuzzy());
        }
        return new StringBuffer(startPoint.toString() + " " + endPoint.toString());
    }

    protected void printOutSequenceHeaderLine(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
    }

    protected List breakSymbolArray(Alphabet theAlphabet, Symbol[] theSymbols, int theStart, int theLength) throws IllegalAlphabetException {
        ArrayList<String> returnList = new ArrayList<String>(theLength / 60 + 1);
        int blockCount = 0;
        int blockIndex = 0;
        StringBuffer tempString = new StringBuffer();
        int i = theStart;
        while (i < theStart + theLength) {
            try {
                theAlphabet.validate(theSymbols[i]);
            }
            catch (IllegalSymbolException e) {
                throw new IllegalAlphabetException(e);
            }
            if (blockIndex == 10) {
                tempString.append(' ');
                blockIndex = 0;
                ++blockCount;
            }
            if (blockCount == 6) {
                returnList.add(tempString.toString());
                tempString.setLength(0);
                blockCount = 0;
                blockIndex = 0;
            }
            tempString.append(theSymbols[i].getToken());
            ++blockIndex;
            ++i;
        }
        if (tempString.length() != 0) {
            returnList.add(tempString.toString());
        }
        return returnList;
    }

    protected void fillBuffer(StringBuffer theBuffer, int theLength) {
        int i = 0;
        while (i < theLength) {
            theBuffer.append(' ');
            ++i;
        }
    }

    protected StringBuffer formatPoint(int theMinIndex, int theMaxIndex, boolean isFuzzy) {
        StringBuffer bufferToReturn = new StringBuffer(LOCATION_WIDTH);
        if (!isFuzzy) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length();
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append(tempString);
        } else if (theMinIndex == Integer.MIN_VALUE && theMaxIndex == Integer.MAX_VALUE) {
            int offset = LOCATION_WIDTH - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('?');
        } else if (theMinIndex == Integer.MIN_VALUE) {
            String tempString = Integer.toString(theMaxIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('<');
            bufferToReturn.append(tempString);
        } else if (theMaxIndex == Integer.MAX_VALUE) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('>');
            bufferToReturn.append(tempString);
        } else if (theMinIndex == theMaxIndex) {
            String tempString = Integer.toString(theMinIndex);
            int offset = LOCATION_WIDTH - tempString.length() - 1;
            this.fillBuffer(bufferToReturn, offset);
            bufferToReturn.append('?');
            bufferToReturn.append(tempString);
        } else {
            System.out.println("Error in formatPoint");
            System.out.println("\tInner: " + theMinIndex);
            System.out.println("\tOuter: " + theMaxIndex);
            System.out.println("\tFuzzy: " + isFuzzy);
        }
        return bufferToReturn;
    }

    static {
        SeqFileFormerFactory.addFactory("Swissprot", new Factory());
    }

    private static class Factory
    extends SeqFileFormerFactory {
        private Factory() {
        }

        protected SeqFileFormer make() {
            return new SwissprotFileFormer(System.out);
        }
    }
}

