/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;

public abstract class AbstractSymbol
implements Symbol {
    protected transient ChangeSupport changeSupport = null;
    protected transient Annotatable.AnnotationForwarder annotationForwarder = null;

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, this.changeSupport);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.generateChangeSupport(ct);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getName();
    }

    public abstract Alphabet getMatches();

    public abstract String getName();

    public abstract char getToken();

    public abstract Annotation getAnnotation();
}

