/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.BasisSymbol;
import org.biojava.bio.symbol.DoubleAlphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.HashedAlphabetIndex;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.InfiniteCrossProductAlphabet;
import org.biojava.bio.symbol.LinearAlphabetIndex;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleAtomicSymbol;
import org.biojava.bio.symbol.SimpleBasisSymbol;
import org.biojava.bio.symbol.SimpleCrossProductAlphabet;
import org.biojava.bio.symbol.SimpleSymbol;
import org.biojava.bio.symbol.SparseCrossProductAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class AlphabetManager {
    private static AlphabetManager am;
    private static Map nameToAlphabet;
    private static Map nameToSymbol;
    private static Map crossProductAlphabets;
    private static Map ambiguitySymbols;
    private static GapSymbol gapSymbol;
    private static Map gapBySize;
    private static Map alphabetToIndex;
    static /* synthetic */ Class class$org$biojava$bio$symbol$AlphabetManager;

    public static AlphabetManager instance() {
        if (am == null) {
            am = new AlphabetManager();
        }
        return am;
    }

    public static Alphabet alphabetForName(String name) throws NoSuchElementException {
        Alphabet alpha = (Alphabet)nameToAlphabet.get(name);
        if (alpha == null) {
            if (name.startsWith("(") && name.endsWith(")")) {
                alpha = AlphabetManager.generateCrossProductAlphaFromName(name);
            } else {
                throw new NoSuchElementException("No alphabet for name " + name + " could be found");
            }
        }
        return alpha;
    }

    public static Symbol symbolForName(String name) throws NoSuchElementException {
        Symbol s = (Symbol)nameToSymbol.get(name);
        if (s == null) {
            throw new NoSuchElementException("Could not find symbol under the name " + name);
        }
        return s;
    }

    public static void registerAlphabet(String name, Alphabet alphabet) {
        nameToAlphabet.put(name, alphabet);
    }

    public static Iterator alphabets() {
        return nameToAlphabet.values().iterator();
    }

    public static Symbol getGapSymbol() {
        return gapSymbol;
    }

    public static Symbol getGapSymbol(List alphas) {
        SizeQueen sq = new SizeQueen(alphas);
        Symbol s = (Symbol)gapBySize.get(sq);
        if (s == null) {
            if (alphas.size() == 0) {
                s = gapSymbol;
            } else if (alphas.size() == 1) {
                Alphabet a = (Alphabet)alphas.get(0);
                s = AlphabetManager.getGapSymbol(a.getAlphabets());
            } else {
                ArrayList<Symbol> symList = new ArrayList<Symbol>(alphas.size());
                Iterator i = alphas.iterator();
                while (i.hasNext()) {
                    Alphabet a = (Alphabet)i.next();
                    symList.add(AlphabetManager.getGapSymbol(a.getAlphabets()));
                }
                try {
                    s = new SimpleBasisSymbol('-', Annotation.EMPTY_ANNOTATION, symList, Alphabet.EMPTY_ALPHABET);
                }
                catch (IllegalSymbolException ise) {
                    throw new BioError(ise, "Assertion Failure: Should be able to make gap basis");
                }
            }
            gapBySize.put(sq, s);
        }
        return s;
    }

    public static AtomicSymbol createSymbol(char token, String name, Annotation annotation) {
        FundamentalAtomicSymbol as = new FundamentalAtomicSymbol(name, token, annotation);
        return as;
    }

    public static Symbol createSymbol(char token, Annotation annotation, List symList, Alphabet alpha) throws IllegalSymbolException {
        Iterator i = symList.iterator();
        int basis = 0;
        int atomC = 0;
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (!(s instanceof BasisSymbol)) continue;
            ++basis;
            if (!(s instanceof AtomicSymbol)) continue;
            ++atomC;
        }
        if (atomC == symList.size()) {
            return new SimpleAtomicSymbol(token, annotation, symList);
        }
        if (basis == symList.size()) {
            return new SimpleBasisSymbol(token, annotation, symList, new SimpleAlphabet(AlphabetManager.expandMatches(alpha, symList, new ArrayList())));
        }
        return new SimpleSymbol(token, annotation, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, symList, new ArrayList())));
    }

    private static Set expandBasis(Alphabet alpha, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            Symbol s = (Symbol)symList.get(indx);
            if (s instanceof AtomicSymbol) {
                built.add(s);
                return AlphabetManager.expandBasis(alpha, symList, built);
            }
            HashSet res = new HashSet();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)i.next();
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add(as);
                res.addAll(AlphabetManager.expandBasis(alpha, symList, built2));
            }
            return res;
        }
        try {
            return Collections.singleton(alpha.getSymbol(built));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should just have legal AtomicSymbol instances.");
        }
    }

    public static Symbol createSymbol(char token, Annotation annotation, Set symSet, Alphabet alpha) throws IllegalSymbolException {
        if (symSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        HashSet<AtomicSymbol> asSet = new HashSet<AtomicSymbol>();
        int len = -1;
        Iterator i = symSet.iterator();
        while (i.hasNext()) {
            Symbol s = (Symbol)i.next();
            if (s instanceof AtomicSymbol) {
                AtomicSymbol as = (AtomicSymbol)s;
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
                continue;
            }
            Iterator j = ((FiniteAlphabet)s.getMatches()).iterator();
            while (j.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)j.next();
                int l = as.getSymbols().size();
                if (len == -1) {
                    len = l;
                } else if (len != l) {
                    throw new IllegalSymbolException("Can't build ambiguity symbol as the symbols have inconsistent length");
                }
                asSet.add(as);
            }
        }
        if (asSet.size() == 0) {
            return AlphabetManager.getGapSymbol();
        }
        if (asSet.size() == 1) {
            return (Symbol)asSet.iterator().next();
        }
        if (len == 1) {
            return new SimpleBasisSymbol(token, annotation, new SimpleAlphabet(asSet));
        }
        List fs = AlphabetManager.factorize(alpha, asSet);
        if (fs == null) {
            return new SimpleSymbol(token, annotation, new SimpleAlphabet(asSet));
        }
        return new SimpleBasisSymbol(token, annotation, fs, new SimpleAlphabet(AlphabetManager.expandBasis(alpha, fs, new ArrayList())));
    }

    public static Alphabet generateCrossProductAlphaFromName(String name) {
        if (!name.startsWith("(") || !name.endsWith(")")) {
            throw new BioError("Can't parse " + name + " into a cross-product alphabet as it is not bracketed");
        }
        name = name.substring(1, name.length() - 1).trim();
        ArrayList<Alphabet> aList = new ArrayList<Alphabet>();
        int i = 0;
        while (i < name.length()) {
            Object alpha = null;
            if (name.charAt(i) == '(') {
                int depth = 1;
                int j = i + 1;
                while (j < name.length() && depth > 0) {
                    char c = name.charAt(j);
                    if (c == '(') {
                        ++depth;
                    } else if (c == ')') {
                        --depth;
                    }
                    ++j;
                }
                if (depth == 0) {
                    aList.add(AlphabetManager.alphabetForName(name.substring(i, j)));
                    i = j;
                    continue;
                }
                throw new BioError("Error parsing alphabet name: could not find matching bracket\n" + name.substring(i));
            }
            int j = name.indexOf(" x ", i);
            if (j < 0) {
                aList.add(AlphabetManager.alphabetForName(name.substring(i).trim()));
                i = name.length();
                continue;
            }
            aList.add(AlphabetManager.alphabetForName(name.substring(i, j).trim()));
            i = j + " x ".length();
        }
        return AlphabetManager.getCrossProductAlphabet(aList);
    }

    public static Alphabet getCrossProductAlphabet(List aList) {
        return AlphabetManager.getCrossProductAlphabet(aList, null);
    }

    public static Alphabet getCrossProductAlphabet(List aList, Alphabet parent) {
        if (aList.size() == 1) {
            return (Alphabet)aList.get(0);
        }
        if (crossProductAlphabets == null) {
            crossProductAlphabets = new HashMap();
        }
        Alphabet cpa = (Alphabet)crossProductAlphabets.get(aList);
        int size = 1;
        if (cpa == null) {
            Iterator i = aList.iterator();
            while (i.hasNext()) {
                Alphabet aa = (Alphabet)i.next();
                if (!(aa instanceof FiniteAlphabet)) {
                    cpa = new InfiniteCrossProductAlphabet(aList);
                    break;
                }
                if (size > 1000) continue;
                size *= ((FiniteAlphabet)aa).size();
            }
            if (cpa == null) {
                try {
                    cpa = size >= 0 && size < 1000 ? new SimpleCrossProductAlphabet(aList, parent) : new SparseCrossProductAlphabet(aList);
                }
                catch (IllegalAlphabetException iae) {
                    throw new BioError("Could not create SimpleCrossProductAlphabet for " + aList + " even though we should be able to. No idea what is wrong.");
                }
            }
            crossProductAlphabets.put(new ArrayList(aList), cpa);
            AlphabetManager.registerAlphabet(cpa.getName(), cpa);
        }
        return cpa;
    }

    private static Set expandMatches(Alphabet parent, List symList, List built) {
        int indx = built.size();
        if (indx < symList.size()) {
            BasisSymbol bs = (BasisSymbol)symList.get(indx);
            if (bs instanceof AtomicSymbol) {
                built.add(bs);
                return AlphabetManager.expandMatches(parent, symList, built);
            }
            HashSet syms = new HashSet();
            Iterator i = ((FiniteAlphabet)bs.getMatches()).iterator();
            while (i.hasNext()) {
                ArrayList<AtomicSymbol> built2 = new ArrayList<AtomicSymbol>(built);
                built2.add((AtomicSymbol)i.next());
                syms.addAll(AlphabetManager.expandMatches(parent, symList, built2));
            }
            return syms;
        }
        try {
            Symbol s = parent.getSymbol(built);
            if (s instanceof AtomicSymbol) {
                return Collections.singleton((AtomicSymbol)s);
            }
            HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
            Iterator i = ((FiniteAlphabet)s.getMatches()).iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)i.next());
            }
            return syms;
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Couldn't create symbol.");
        }
    }

    public static List factorize(Alphabet alpha, Set symSet) throws IllegalSymbolException {
        List alphas = alpha.getAlphabets();
        ArrayList<Symbol> facts = new ArrayList<Symbol>();
        int size = symSet.size();
        HashSet<AtomicSymbol> syms = new HashSet<AtomicSymbol>();
        int col = 0;
        while (col < alphas.size()) {
            Alphabet a = (Alphabet)alphas.get(col);
            Iterator i = symSet.iterator();
            while (i.hasNext()) {
                syms.add((AtomicSymbol)((AtomicSymbol)i.next()).getSymbols().get(col));
            }
            int s = syms.size();
            if (size % s != 0) {
                return null;
            }
            size /= s;
            facts.add(a.getAmbiguity(syms));
            syms.clear();
            ++col;
        }
        if (size != 1) {
            return null;
        }
        return facts;
    }

    private static AtomicSymbol symbolFromXML(Element symE, WellKnownAlphabet alpha) {
        char token = '\u0000';
        String name = null;
        String description = null;
        NodeList children = symE.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Element) {
                Element el = (Element)n;
                String nodeName = el.getNodeName();
                String content = el.getFirstChild().getNodeValue();
                if (nodeName.equals("short")) {
                    token = content.charAt(0);
                } else if (nodeName.equals("long")) {
                    name = content;
                } else if (nodeName.equals("description")) {
                    description = content;
                }
            }
            ++i;
        }
        WellKnownSymbol sym = new WellKnownSymbol(alpha, token, name, new SimpleAnnotation());
        try {
            sym.getAnnotation().setProperty("description", description);
        }
        catch (ChangeVetoException cve) {
            throw new BioError(cve, "Assertion voilated: there should be nothing to veto this property");
        }
        return sym;
    }

    private static Symbol ambiguityFromXML(Alphabet alpha, Element symE, Map nameToSym) throws IllegalSymbolException {
        char token = '\u0000';
        String name = null;
        String description = null;
        HashSet<Symbol> syms = new HashSet<Symbol>();
        NodeList children = symE.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Element) {
                Element el = (Element)n;
                String nodeName = el.getNodeName();
                if (nodeName.equals("symbol")) {
                    NodeList symC = el.getChildNodes();
                    int j = 0;
                    while (j < symC.getLength()) {
                        Node en = symC.item(j);
                        if (en instanceof Element) {
                            Element eel = (Element)en;
                            String eName = eel.getNodeName();
                            String content = eel.getFirstChild().getNodeValue();
                            if (eName.equals("short")) {
                                token = content.charAt(0);
                            } else if (eName.equals("long")) {
                                name = content;
                            } else if (eName.equals("description")) {
                                description = content;
                            }
                        }
                        ++j;
                    }
                } else if (nodeName.equals("symbolref")) {
                    String refName = el.getAttribute("name");
                    Symbol s = (Symbol)nameToSym.get(refName);
                    if (s == null) {
                        throw new IllegalSymbolException("Got symbol ref to " + refName + " but it doesn't match anything");
                    }
                    syms.add(s);
                }
            }
            ++i;
        }
        Symbol sym = AlphabetManager.createSymbol(token, Annotation.EMPTY_ANNOTATION, syms, alpha);
        return sym;
    }

    private static SimpleAlphabet alphabetFromXML(Element alph, Map nameToSym) throws BioException {
        nameToSym = new HashMap<String, AtomicSymbol>(nameToSym);
        WellKnownAlphabet alphabet = new WellKnownAlphabet();
        NodeList children = alph.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Element) {
                Element el = (Element)n;
                try {
                    String name = el.getNodeName();
                    if (name.equals("description")) {
                        alphabet.getAnnotation().setProperty("description", el.getFirstChild().getNodeValue());
                    } else if (name.equals("symbol")) {
                        AtomicSymbol sym = AlphabetManager.symbolFromXML(el, alphabet);
                        String symName = el.getAttribute("name");
                        if (symName != null) {
                            nameToSym.put(symName, sym);
                        }
                        alphabet.addSymbol(sym);
                    } else if (name.equals("symbolref")) {
                        alphabet.addSymbol((Symbol)nameToSym.get(el.getAttribute("name")));
                    } else if (name.equals("ambiguity")) {
                        alphabet.addAmbiguity(AlphabetManager.ambiguityFromXML(alphabet, el, nameToSym));
                    }
                }
                catch (Exception e) {
                    throw new BioException(e, "Couldn't parse element " + el);
                }
            }
            ++i;
        }
        return alphabet;
    }

    public static AlphabetIndex getAlphabetIndex(FiniteAlphabet alpha) {
        int generateIndexSize = 160;
        AlphabetIndex ai = (AlphabetIndex)alphabetToIndex.get(alpha);
        if (ai == null) {
            int size = alpha.size();
            ai = size <= 160 ? new LinearAlphabetIndex(alpha) : new HashedAlphabetIndex(alpha);
            alphabetToIndex.put(alpha, ai);
        }
        return ai;
    }

    public static AlphabetIndex getAlphabetIndex(Symbol[] syms) throws IllegalSymbolException, BioException {
        return new LinearAlphabetIndex(syms);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        alphabetToIndex = new HashMap();
        nameToAlphabet = new HashMap();
        nameToSymbol = new HashMap();
        ambiguitySymbols = new HashMap();
        gapSymbol = new GapSymbol();
        gapBySize = new HashMap();
        gapBySize.put(new SizeQueen(new ArrayList()), gapSymbol);
        try {
            gapBySize.put(new SizeQueen(Arrays.asList(DoubleAlphabet.getInstance())), new SimpleBasisSymbol('-', Annotation.EMPTY_ANNOTATION, Arrays.asList(gapSymbol), Alphabet.EMPTY_ALPHABET));
        }
        catch (IllegalSymbolException ise) {
            throw new BioError(ise, "Assertion Failure: Should be able to make gap basis");
        }
        ambiguitySymbols.put(new HashSet(), gapSymbol);
        try {
            InputStream alphabetStream = (class$org$biojava$bio$symbol$AlphabetManager == null ? (class$org$biojava$bio$symbol$AlphabetManager = AlphabetManager.class$("org.biojava.bio.symbol.AlphabetManager")) : class$org$biojava$bio$symbol$AlphabetManager).getClassLoader().getResourceAsStream("org/biojava/bio/symbol/AlphabetManager.xml");
            if (alphabetStream == null) {
                throw new BioError("Couldn't locate AlphabetManager.xml.  Badly built biojava archive?");
            }
            InputSource is = new InputSource(alphabetStream);
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = parser.parse(is);
            NodeList children = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node cnode = children.item(i);
                if (cnode instanceof Element) {
                    Element child = (Element)cnode;
                    String name = child.getNodeName();
                    if (name.equals("symbol")) {
                        nameToSymbol.put(child.getAttribute("name"), AlphabetManager.symbolFromXML(child, null));
                    } else if (name.equals("alphabet")) {
                        String alphaName = child.getAttribute("name");
                        String parentName = child.getAttribute("parent");
                        try {
                            SimpleAlphabet alpha = AlphabetManager.alphabetFromXML(child, nameToSymbol);
                            if (parentName != null && parentName.length() != 0) {
                                alphaName = parentName + "-" + alphaName;
                                FiniteAlphabet pa = (FiniteAlphabet)AlphabetManager.alphabetForName(parentName);
                                Iterator j = pa.iterator();
                                while (j.hasNext()) {
                                    alpha.addSymbol((Symbol)j.next());
                                }
                                if (pa instanceof SimpleAlphabet) {
                                    Iterator j2 = ((SimpleAlphabet)pa).ambiguities();
                                    while (j2.hasNext()) {
                                        alpha.addAmbiguity((Symbol)j2.next());
                                    }
                                }
                            }
                            alpha.setName(alphaName);
                            AlphabetManager.registerAlphabet(alphaName, alpha);
                        }
                        catch (Exception e) {
                            throw new BioError(e, "Couldn't construct alphabet " + alphaName);
                        }
                    }
                }
                ++i;
            }
        }
        catch (SAXParseException spe) {
            throw new BioError(spe, ((SAXException)spe).toString() + spe.getLineNumber() + ":" + spe.getColumnNumber());
        }
        catch (Exception t) {
            throw new BioError(t, "Unable to initialize AlphabetManager");
        }
    }

    private static final class SizeQueen
    extends AbstractList {
        private final List alphas;

        public SizeQueen(List alphas) {
            this.alphas = alphas;
        }

        public int size() {
            return this.alphas.size();
        }

        public Object get(int pos) {
            Alphabet a = (Alphabet)this.alphas.get(pos);
            List al = a.getAlphabets();
            int size = al.size();
            if (size > 1) {
                return new SizeQueen(al);
            }
            return new Integer(size);
        }
    }

    private static class GapSymbol
    implements Symbol,
    Serializable {
        public String getName() {
            return "gap";
        }

        public char getToken() {
            return '-';
        }

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public Alphabet getMatches() {
            return Alphabet.EMPTY_ALPHABET;
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }

    private static class WellKnownSymbol
    extends FundamentalAtomicSymbol
    implements Serializable {
        WellKnownAlphabet alpha;

        public WellKnownSymbol(WellKnownAlphabet alpha, char token, String name, Annotation a) {
            super(name, token, a);
            this.alpha = alpha;
        }

        private Object writeReplace() {
            return new OPH(this.alpha, this.getName());
        }

        private static class OPH
        implements Serializable {
            private WellKnownAlphabet alpha;
            private String name;

            public OPH(WellKnownAlphabet alpha, String name) {
                this.alpha = alpha;
                this.name = name;
            }

            private Object readResolve() throws ObjectStreamException {
                try {
                    if (this.alpha != null) {
                        return this.alpha.getParser("name").parseToken(this.name);
                    }
                    return AlphabetManager.symbolForName(this.name);
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve symbol " + this.name + " as there was no parser");
                }
                catch (IllegalSymbolException ise) {
                    throw new InvalidObjectException("Couldn't resolve symbol " + this.name + ": " + ise.getMessage());
                }
            }
        }
    }

    private static class WellKnownAlphabet
    extends SimpleAlphabet
    implements Serializable {
        private WellKnownAlphabet() {
        }

        private Object writeReplace() {
            return new OPH(this.getName());
        }

        private static class OPH
        implements Serializable {
            private String name;

            public OPH(String name) {
                this.name = name;
            }

            public OPH() {
            }

            /*
             * WARNING - void declaration
             */
            private Object readResolve() throws ObjectStreamException {
                try {
                    void ex;
                    Alphabet a = AlphabetManager.alphabetForName(this.name);
                    return ex;
                }
                catch (NoSuchElementException ex) {
                    throw new InvalidObjectException("Couldn't resolve alphabet " + this.name);
                }
            }
        }
    }
}

