/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.seq.io.IntegerParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.SingletonList;
import org.biojava.utils.StaticMemberPlaceHolder;

public class IntegerAlphabet
implements Alphabet,
Serializable {
    private static final IntegerAlphabet INSTANCE = new IntegerAlphabet();
    static /* synthetic */ Class class$org$biojava$bio$symbol$IntegerAlphabet;

    private Object writeReplace() throws ObjectStreamException {
        try {
            return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$IntegerAlphabet == null ? (class$org$biojava$bio$symbol$IntegerAlphabet = IntegerAlphabet.class$("org.biojava.bio.symbol.IntegerAlphabet")) : class$org$biojava$bio$symbol$IntegerAlphabet).getField("INSTANCE"));
        }
        catch (NoSuchFieldException nsfe) {
            throw new NotSerializableException(nsfe.getMessage());
        }
    }

    public static SymbolList fromArray(int[] iArray) {
        return new IntegerArray(iArray);
    }

    public static IntegerAlphabet getInstance() {
        return INSTANCE;
    }

    public IntegerSymbol getSymbol(int val) {
        return new IntegerSymbol(val);
    }

    public Symbol getGapSymbol() {
        return AlphabetManager.getGapSymbol(this.getAlphabets());
    }

    public Annotation getAnnotation() {
        return Annotation.EMPTY_ANNOTATION;
    }

    public List getAlphabets() {
        return new SingletonList(this);
    }

    public Symbol getSymbol(List symList) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    public Symbol getAmbiguity(Set symSet) throws IllegalSymbolException {
        throw new BioError("Unimplemneted method");
    }

    public boolean contains(Symbol s) {
        return s instanceof IntegerSymbol;
    }

    public void validate(Symbol s) throws IllegalSymbolException {
        if (!this.contains(s)) {
            throw new IllegalSymbolException("Only symbols of type IntegerAlphabet.IntegerSymbol are valid for this alphabet.\n(" + s.getClass() + ") " + s.getName());
        }
    }

    public String getName() {
        return "Alphabet of all integers.";
    }

    public SymbolParser getParser(String name) {
        if (name.equals("token")) {
            return new IntegerParser();
        }
        throw new NoSuchElementException(name + " parser not supported by IntegerAlphabet yet");
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class IntegerArray
    extends AbstractSymbolList
    implements Serializable {
        private final int[] iArray;

        public Alphabet getAlphabet() {
            return INSTANCE;
        }

        public Symbol symbolAt(int i) {
            return new IntegerSymbol(this.iArray[i - 1]);
        }

        public int length() {
            return this.iArray.length;
        }

        public IntegerArray(int[] iArray) {
            this.iArray = iArray;
        }
    }

    public static class IntegerSymbol
    implements AtomicSymbol,
    Serializable {
        private final int val;
        private final Alphabet matches;

        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }

        public String getName() {
            return this.val + "";
        }

        public char getToken() {
            return '#';
        }

        public int intValue() {
            return this.val;
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        protected IntegerSymbol(int val) {
            this.val = val;
            this.matches = new SingletonAlphabet(this);
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

