/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import org.biojava.bio.symbol.AbstractRangeLocation;
import org.biojava.bio.symbol.Location;

public class RangeLocation
extends AbstractRangeLocation
implements Serializable {
    private int min;
    private int max;

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public RangeLocation(int min, int max) throws IndexOutOfBoundsException {
        if (max < min) {
            throw new IndexOutOfBoundsException("max must exceed min: min=" + min + ", max=" + max);
        }
        this.min = min;
        this.max = max;
    }

    public Location translate(int dist) {
        return new RangeLocation(this.min + dist, this.max + dist);
    }

    public String toString() {
        return "[" + this.getMin() + "," + this.getMax() + "]";
    }
}

