/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm;

import java.util.Iterator;
import java.util.Set;
import org.biojava.stats.svm.ItemValue;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;

public abstract class AbstractSVMClassifierModel
implements SVMClassifierModel {
    public void setThreshold() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setThreshold not supported by " + this.getClass());
    }

    public void setAlpha(Object item, double alpha) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setAlpha not supported by " + this.getClass());
    }

    public void addItem(Object item) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addItem not supported by " + this.getClass());
    }

    public void addItemAlpha(Object item, double alpha) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addItemAlpha not supported by " + this.getClass());
    }

    public void removeItem(Object item) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("removeItem not supported by " + this.getClass());
    }

    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("clear not supported by " + this.getClass());
    }

    public double classify(Object item) {
        double delta = 0.0;
        SVMKernel kernel = this.getKernel();
        double threshold = this.getThreshold();
        Iterator i = this.itemAlphas().iterator();
        while (i.hasNext()) {
            ItemValue itemValue = (ItemValue)i.next();
            double alpha = itemValue.getValue();
            if (alpha == 0.0) continue;
            delta += alpha * kernel.evaluate(itemValue.getItem(), item);
        }
        return delta - threshold;
    }

    public abstract double getAlpha(Object var1);

    public abstract Set itemAlphas();

    public abstract Set items();

    public abstract double getThreshold();

    public abstract void setThreshold(double var1) throws UnsupportedOperationException;

    public abstract SVMKernel getKernel();
}

