/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.biojava.stats.svm.PolynomialKernel;
import org.biojava.stats.svm.RadialBaseKernel;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.SVMKernel;
import org.biojava.stats.svm.SimpleSVMClassifierModel;
import org.biojava.stats.svm.SparseVector;

public class SVM_Light {
    public static LabelledVector parseExample(String ex) throws NumberFormatException {
        String comment = null;
        int hashPos = ex.indexOf(35);
        if (hashPos >= 0) {
            comment = ex.substring(hashPos + 1);
            ex = ex.substring(0, hashPos);
        }
        StringTokenizer toke = new StringTokenizer(ex);
        double label = Double.parseDouble(toke.nextToken());
        int size = toke.countTokens();
        SparseVector v = new SparseVector(size);
        while (toke.hasMoreTokens()) {
            String dim = toke.nextToken();
            int cut = dim.indexOf(58);
            if (cut < 0) {
                throw new NumberFormatException("Bad dimension " + dim);
            }
            int dnum = Integer.parseInt(dim.substring(0, cut));
            double dval = Double.parseDouble(dim.substring(cut + 1));
            v.put(dnum, dval);
        }
        return new LabelledVector(v, label, comment);
    }

    public static String vectorToString(SparseVector v) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        int i = 0;
        while (i < v.size()) {
            double x = v.getValueAtIndex(i);
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(v.getDimAtIndex(i));
            sb.append(':');
            sb.append(x);
            ++i;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static SVMClassifierModel readModelFile(String fileName) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(fileName));
        String format = SVM_Light.firstToken(r.readLine());
        String kType = SVM_Light.firstToken(r.readLine());
        String dParam = SVM_Light.firstToken(r.readLine());
        String gParam = SVM_Light.firstToken(r.readLine());
        String sParam = SVM_Light.firstToken(r.readLine());
        String rParam = SVM_Light.firstToken(r.readLine());
        String uParam = r.readLine();
        String numSV = SVM_Light.firstToken(r.readLine());
        String threshString = SVM_Light.firstToken(r.readLine());
        SVMKernel kernel = null;
        try {
            String line;
            int size = Integer.parseInt(numSV);
            switch (Integer.parseInt(kType)) {
                case 0: {
                    kernel = SparseVector.kernel;
                    break;
                }
                case 1: {
                    int order = Integer.parseInt(dParam);
                    PolynomialKernel k = new PolynomialKernel();
                    k.setOrder(order);
                    k.setNestedKernel(SparseVector.kernel);
                    kernel = k;
                    break;
                }
                case 2: {
                    RadialBaseKernel rbk = new RadialBaseKernel();
                    double width = Double.parseDouble(gParam);
                    rbk.setWidth(width);
                    rbk.setNestedKernel(SparseVector.kernel);
                    kernel = rbk;
                    break;
                }
                default: {
                    throw new IOException("Couldn't create kernel");
                }
            }
            SimpleSVMClassifierModel model = new SimpleSVMClassifierModel(kernel);
            model.setThreshold(Double.parseDouble(threshString));
            while ((line = r.readLine()) != null) {
                void var19_19;
                LabelledVector ex = SVM_Light.parseExample((String)var19_19);
                model.addItemAlpha(ex.getVector(), ex.getLabel());
            }
            r.close();
            return model;
        }
        catch (NumberFormatException ex) {
            throw new IOException("Couldn't parse model file");
        }
    }

    public static void writeModelFile(SVMClassifierModel model, String fileName) throws IOException {
        SVMKernel k = model.getKernel();
        int kType = 0;
        int d = 3;
        double g = 1.0;
        double s = 1.0;
        double r = 1.0;
        String u = "empty";
        if (k == SparseVector.kernel) {
            kType = 0;
        } else if (k instanceof PolynomialKernel) {
            kType = 1;
            d = (int)((PolynomialKernel)k).getOrder();
        } else if (k instanceof RadialBaseKernel) {
            kType = 2;
            g = ((RadialBaseKernel)k).getWidth();
        } else {
            throw new IOException("Can't write SVM_Light file with kernel type " + k.getClass().toString());
        }
        PrintWriter pw = new PrintWriter(new FileWriter(fileName));
        pw.println("SVM-light Version V3.01");
        pw.println("" + kType + " # kernel type");
        pw.println("" + d + " # kernel parameter -d");
        pw.println("" + g + " # kernel parameter -g");
        pw.println("" + s + " # kernel parameter -s");
        pw.println("" + r + " # kernel parameter -r");
        pw.println(u + " # kernel parameter -u");
        int numSV = 0;
        Iterator i = model.items().iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (model.getAlpha(item) == 0.0) continue;
            ++numSV;
        }
        pw.println("" + numSV + " # number of support vectors");
        pw.println("" + model.getThreshold() + " # threshold b");
        Iterator i2 = model.items().iterator();
        while (i2.hasNext()) {
            Object item = i2.next();
            if (model.getAlpha(item) == 0.0) continue;
            pw.print(model.getAlpha(i2));
            SparseVector v = (SparseVector)item;
            int j = 0;
            while (j <= v.maxIndex()) {
                double x = v.get(j);
                if (x != 0.0) {
                    pw.print(" " + j + ":" + x);
                }
                ++j;
            }
            pw.println("");
        }
        pw.close();
    }

    public static String firstToken(String s) {
        int ndx = s.indexOf(" ");
        if (ndx < 0) {
            return s;
        }
        return s.substring(0, ndx);
    }

    public static class LabelledVector {
        private SparseVector v;
        private double label;
        private String comment = null;

        public LabelledVector(SparseVector v, double label) {
            this.v = v;
            this.label = label;
        }

        public LabelledVector(SparseVector v, double label, String comment) {
            this.v = v;
            this.label = label;
            this.comment = comment;
        }

        public SparseVector getVector() {
            return this.v;
        }

        public double getLabel() {
            return this.label;
        }

        public String getComment() {
            return this.comment;
        }
    }
}

