/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.query;

import org.biojava.utils.query.Tuple;
import org.biojava.utils.query.Type;
import org.biojava.utils.query.TypeCastException;

class PermutedTuple
implements Tuple {
    private final Tuple source;
    private final TypeList typeList;

    public PermutedTuple(Tuple source, TypeList typeList) throws IllegalArgumentException {
        if (!typeList.getOriginalType().isAssignableFrom(source.getTypeList())) {
            throw new TypeCastException("Can't cast from " + source.getTypeList() + " to " + typeList.getOriginalType());
        }
        this.source = source;
        this.typeList = typeList;
    }

    public Object getObject(int indx) {
        return this.source.getObject(this.typeList.mapIndex(indx));
    }

    public Tuple.TypeList getTypeList() {
        return this.typeList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(");
        sb.append(this.typeList.mapIndex(0) + ":" + this.getObject(0).toString());
        int i = 1;
        while (i < this.typeList.size()) {
            sb.append("," + this.typeList.mapIndex(i) + ":");
            sb.append(this.getObject(i).toString());
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int hc = this.getObject(0).hashCode();
        int i = 1;
        while (i < this.getTypeList().size()) {
            hc ^= this.getObject(i).hashCode();
            ++i;
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o instanceof Tuple) {
            Tuple tup = (Tuple)o;
            if (!this.getTypeList().equals(tup.getTypeList())) {
                return false;
            }
            int i = 0;
            while (i < this.getTypeList().size()) {
                if (!this.getObject(i).equals(tup.getObject(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    static class TypeList
    extends Tuple.TypeList {
        private final int[] order;
        private final Tuple.TypeList typeList;

        public TypeList(int[] order, Tuple.TypeList typeList) {
            this.order = order;
            this.typeList = typeList;
        }

        public int size() {
            return this.order.length;
        }

        public int mapIndex(int indx) {
            try {
                return this.order[indx];
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new IndexOutOfBoundsException("index " + indx + " not in array length " + this.order.length);
            }
        }

        public Type getType(int indx) {
            return this.typeList.getType(this.mapIndex(indx));
        }

        public Type getOriginalType() {
            return this.typeList;
        }
    }
}

