/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.xml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.biojava.utils.xml.AppException;
import org.biojava.utils.xml.Initializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBeans {
    public static final XMLBeans INSTANCE = new XMLBeans();

    protected XMLBeans() {
    }

    public Object instantiateBean(Element bel) throws AppException {
        return this.instantiateBean(bel, ClassLoader.getSystemClassLoader(), new HashMap());
    }

    public Object instantiateBean(Element bel, ClassLoader cloader, Map beanRefs) throws AppException {
        String cl = bel.getAttribute("jclass");
        if (cl == null) {
            throw new AppException("No jclass attribute");
        }
        Object bean = null;
        try {
            Class<?> clazz = cloader.loadClass(cl);
            bean = clazz.newInstance();
            this.configureBean(bean, bel, beanRefs);
            if (bean instanceof Initializable) {
                ((Initializable)bean).init();
            }
        }
        catch (ClassNotFoundException ex) {
            throw new AppException("Couldn't load bean class " + cl);
        }
        catch (ClassCastException ex) {
            throw new AppException("Does not implement AppBean: " + cl);
        }
        catch (InstantiationException ex) {
            throw new AppException("Couldn't intantiate bean " + cl);
        }
        catch (IllegalAccessException ex) {
            throw new AppException("Couldn't access constructor for bean " + cl);
        }
        return bean;
    }

    private void configureBean(Object bean, Element el, Map refs) throws AppException {
        Class<?> clazz = bean.getClass();
        Node child = el.getFirstChild();
        while (child != null) {
            if (child instanceof Element) {
                String value;
                String name;
                Element echild = (Element)child;
                String tag = echild.getTagName();
                if (tag.equals("string")) {
                    name = echild.getAttribute("name");
                    value = echild.getAttribute("value");
                    this.setProp(clazz, bean, name, value, value.getClass());
                } else if (tag.equals("bean")) {
                    name = echild.getAttribute("name");
                    String ref = echild.getAttribute("ref");
                    Object targ = null;
                    if (!ref.equals("")) {
                        targ = refs.get(ref);
                        if (targ == null) {
                            throw new NullPointerException("Can't find target for: " + ref);
                        }
                    } else {
                        targ = this.instantiateBean(echild);
                    }
                    this.setProp(clazz, bean, name, targ, targ.getClass());
                } else if (tag.equals("int")) {
                    name = echild.getAttribute("name");
                    value = echild.getAttribute("value");
                    try {
                        int val = Integer.parseInt(value);
                        this.setProp(clazz, bean, name, new Integer(val), Integer.TYPE);
                    }
                    catch (NumberFormatException ex) {
                        throw new AppException("Invalid int: " + value);
                    }
                } else if (tag.equals("double")) {
                    name = echild.getAttribute("name");
                    value = echild.getAttribute("value");
                    try {
                        double val = Double.parseDouble(value);
                        this.setProp(clazz, bean, name, new Double(val), Double.TYPE);
                    }
                    catch (NumberFormatException ex) {
                        throw new AppException("Invalid double: " + value);
                    }
                } else if (tag.equals("boolean")) {
                    name = echild.getAttribute("name");
                    value = echild.getAttribute("value");
                    Boolean val = Boolean.valueOf(value);
                    this.setProp(clazz, bean, name, val, Boolean.TYPE);
                } else if (tag.equals("child")) {
                    if (!(bean instanceof Collection)) {
                        throw new AppException("Only Collections can have children");
                    }
                    Object childBean = this.instantiateBean(echild);
                    ((Collection)bean).add(childBean);
                }
            }
            child = child.getNextSibling();
        }
    }

    private void setProp(Class clazz, Object bean, String prop, Object value, Class ourType) throws AppException {
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException ex) {
            throw new AppException("Couldn't introspect class " + bean.getClass().getName());
        }
        PropertyDescriptor[] descs = bi.getPropertyDescriptors();
        int i = 0;
        while (i < descs.length) {
            if (descs[i].getName().equals(prop)) {
                PropertyDescriptor desc = descs[i];
                if (!desc.getPropertyType().isAssignableFrom(ourType)) {
                    throw new AppException("Property " + prop + " is not assignable from " + ourType.getName());
                }
                Object[] obj = new Object[]{value};
                try {
                    desc.getWriteMethod().invoke(bean, obj);
                }
                catch (Exception ex) {
                    throw new AppException("Invocation failed");
                }
                return;
            }
            ++i;
        }
        throw new AppException("Couldn't find property " + prop + " in class " + clazz.getName());
    }
}

