/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.Iterator;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionTrainerContext;
import org.biojava.bio.dist.IgnoreCountsTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public abstract class AbstractDistribution
implements Distribution {
    protected transient ChangeSupport changeSupport = null;
    protected transient Distribution.NullModelForwarder nullModelForwarder = null;

    protected void generateChangeSupport(ChangeType ct) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        if ((ct == null || ct == Distribution.NULL_MODEL) && this.nullModelForwarder == null) {
            this.nullModelForwarder = new Distribution.NullModelForwarder(this, this.changeSupport);
            this.getNullModel().addChangeListener(this.nullModelForwarder, Distribution.WEIGHTS);
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.generateChangeSupport(ct);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    protected abstract void setWeightImpl(AtomicSymbol var1, double var2) throws IllegalSymbolException, ChangeVetoException;

    public final void setWeight(Symbol sym, double weight) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.doSetWeight(sym, weight);
        } else {
            ChangeEvent ce = new ChangeEvent(this, Distribution.WEIGHTS, new Object[]{sym, new Double(weight)}, new Object[]{sym, new Double(this.getWeight(sym))});
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                this.doSetWeight(sym, weight);
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    private void doSetWeight(Symbol sym, double weight) throws IllegalSymbolException, ChangeVetoException {
        if (sym instanceof AtomicSymbol) {
            this.setWeightImpl((AtomicSymbol)sym, weight);
        } else {
            FiniteAlphabet fa = (FiniteAlphabet)sym.getMatches();
            Iterator si = fa.iterator();
            while (si.hasNext()) {
                AtomicSymbol as = (AtomicSymbol)si.next();
                this.setWeightImpl(as, weight);
            }
        }
    }

    protected abstract void setNullModelImpl(Distribution var1) throws IllegalAlphabetException, ChangeVetoException;

    public final void setNullModel(Distribution nullModel) throws IllegalAlphabetException, ChangeVetoException {
        if (nullModel.getAlphabet() != this.getAlphabet()) {
            throw new IllegalAlphabetException("Could not use distribution " + nullModel + " as its alphabet is " + nullModel.getAlphabet().getName() + " and this distribution's alphabet is " + this.getAlphabet().getName());
        }
        Distribution oldModel = this.getNullModel();
        if (this.nullModelForwarder != null) {
            if (oldModel != null) {
                oldModel.removeChangeListener(this.nullModelForwarder);
            }
            nullModel.addChangeListener(this.nullModelForwarder);
        }
        if (this.changeSupport == null) {
            this.setNullModelImpl(nullModel);
        } else {
            ChangeEvent ce = new ChangeEvent(this, Distribution.NULL_MODEL, nullModel, oldModel);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(ce);
                this.setNullModelImpl(nullModel);
                this.changeSupport.firePostChangeEvent(ce);
            }
        }
    }

    public final double getWeight(Symbol sym) throws IllegalSymbolException {
        if (sym instanceof AtomicSymbol) {
            return this.getWeightImpl((AtomicSymbol)sym);
        }
        Alphabet ambA = sym.getMatches();
        if (((FiniteAlphabet)ambA).size() == 0) {
            this.getAlphabet().validate(sym);
            return 0.0;
        }
        if (ambA instanceof FiniteAlphabet) {
            FiniteAlphabet fa = (FiniteAlphabet)ambA;
            double sum = 0.0;
            Iterator i = fa.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof AtomicSymbol)) {
                    throw new BioError("Assertion Failure: Not an instance of AtomicSymbol: " + obj);
                }
                AtomicSymbol as = (AtomicSymbol)obj;
                sum += this.getWeightImpl(as);
            }
            return sum;
        }
        throw new IllegalSymbolException("Can't find weight for infinite set of symbols matched by " + sym.getName());
    }

    protected abstract double getWeightImpl(AtomicSymbol var1) throws IllegalSymbolException;

    public Symbol sampleSymbol() {
        double p = Math.random();
        try {
            Iterator i = ((FiniteAlphabet)this.getAlphabet()).iterator();
            while (i.hasNext()) {
                AtomicSymbol s = (AtomicSymbol)i.next();
                if (!((p -= this.getWeight(s)) <= 0.0)) continue;
                return s;
            }
            StringBuffer sb = new StringBuffer();
            Iterator i2 = ((FiniteAlphabet)this.getAlphabet()).iterator();
            while (i2.hasNext()) {
                AtomicSymbol s = (AtomicSymbol)i2.next();
                double w = this.getWeight(s);
                sb.append("\t" + s.getName() + " -> " + w + "\n");
            }
            throw new BioError("Could not find a symbol to emit from alphabet " + this.getAlphabet() + ". Do the probabilities sum to 1?" + "\np=" + p + "\n" + sb.toString());
        }
        catch (IllegalSymbolException ire) {
            throw new BioError(ire, "Unable to itterate over all symbols in alphabet - things changed beneath me!");
        }
    }

    public void registerWithTrainer(DistributionTrainerContext dtc) {
        dtc.registerTrainer(this, IgnoreCountsTrainer.getInstance());
    }

    public abstract Distribution getNullModel();

    public abstract Alphabet getAlphabet();
}

