/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.Location;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class TickFeatureRenderer
extends AbstractChangeable
implements FeatureRenderer {
    public static final ChangeType FILL = new ChangeType("The fill paint has changed", "org.biojava.bio.gui.sequence.TickFeatureRenderer", "FILL");
    public static final ChangeType OUTLINE = new ChangeType("The outline paint has changed", "org.biojava.bio.gui.sequence.TickFeatureRenderer", "OUTLINE");
    public static final ChangeType DEPTH = new ChangeType("The size of the arrow has changed", "org.biojava.bio.gui.sequence.TickFeatureRenderer", "DEPTH");
    private Paint fill = Color.blue;
    private Paint outline = Color.black;
    private double depth = 25.0;

    public void setFill(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, FILL, p, this.fill));
                cs.firePreChangeEvent(ce);
                this.fill = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.fill = p;
        }
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setOutline(Paint p) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.REPAINT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.REPAINT, null, null, new ChangeEvent(this, OUTLINE, p, this.outline));
                cs.firePreChangeEvent(ce);
                this.outline = p;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.outline = p;
        }
    }

    public Paint getOutline() {
        return this.outline;
    }

    public void setDepth(double arrowSize) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport cs;
            ChangeSupport changeSupport = cs = this.getChangeSupport(SequenceRenderContext.LAYOUT);
            synchronized (changeSupport) {
                ChangeEvent ce = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, DEPTH, new Double(this.depth), new Double(arrowSize)));
                cs.firePreChangeEvent(ce);
                this.depth = arrowSize;
                cs.firePostChangeEvent(ce);
            }
        } else {
            this.depth = arrowSize;
        }
    }

    public double getDepth() {
        return this.depth;
    }

    public void renderFeature(Graphics2D g, Feature f, SequenceRenderContext src) {
        Paint prevPaint;
        GeneralPath s = null;
        Location loc = f.getLocation();
        float min = (float)src.sequenceToGraphics(loc.getMin());
        float max = (float)src.sequenceToGraphics(loc.getMax());
        float pos = (min + max) / 2.0f;
        float fDepth = (float)this.depth;
        float fDepthByThree = fDepth / 3.0f;
        if (f instanceof StrandedFeature) {
            StrandedFeature.Strand strand = ((StrandedFeature)f).getStrand();
            if (src.getDirection() == 0) {
                if (strand == StrandedFeature.POSITIVE) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo(pos, 0.0f);
                    path.lineTo(pos, fDepth);
                    path.lineTo(pos + fDepthByThree, fDepth);
                    path.lineTo(pos, fDepth - fDepthByThree);
                    path.closePath();
                    s = path;
                } else if (strand == StrandedFeature.NEGATIVE) {
                    GeneralPath path = new GeneralPath();
                    path.moveTo(pos, 0.0f);
                    path.lineTo(pos, fDepth);
                    path.lineTo(pos - fDepthByThree, fDepth);
                    path.lineTo(pos, fDepth - fDepthByThree);
                    path.closePath();
                    s = path;
                }
            } else if (strand == StrandedFeature.POSITIVE) {
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, pos);
                path.lineTo(fDepth, pos);
                path.lineTo(fDepth, pos + fDepthByThree);
                path.lineTo(fDepth - fDepthByThree, pos);
                path.closePath();
                s = path;
            } else if (strand == StrandedFeature.NEGATIVE) {
                GeneralPath path = new GeneralPath();
                path.moveTo(0.0f, pos);
                path.lineTo(fDepth, pos);
                path.lineTo(fDepth, pos - fDepthByThree);
                path.lineTo(fDepth - fDepthByThree, pos);
                path.closePath();
                s = path;
            }
        }
        if (this.fill != null) {
            prevPaint = g.getPaint();
            g.setPaint(this.fill);
            g.fill(s);
            g.setPaint(prevPaint);
        }
        if (this.outline != null) {
            prevPaint = g.getPaint();
            g.setPaint(this.outline);
            g.draw(s);
            g.setPaint(prevPaint);
        }
    }

    public double getDepth(SequenceRenderContext src) {
        return this.depth;
    }

    public FeatureHolder processMouseEvent(FeatureHolder hits, SequenceRenderContext src, MouseEvent me) {
        return hits;
    }
}

