/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASComponentFeature;
import org.biojava.bio.program.das.DASFeatureSet;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.MergeFeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.impl.AssembledSymbolList;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.bio.seq.io.SimpleSequenceBuilder;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.LocationTools;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.CacheReference;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DASSequence
implements Sequence,
RealizingFeatureHolder {
    public static final ChangeType ANNOTATIONS = new ChangeType("Annotation sets have been added or removed from the DAS sequence", "org.biojava.bio.program.das.DASSequence", "ANNOTATIONS", FeatureHolder.FEATURES);
    public static final String PROPERTY_ANNOTATIONSERVER = "org.biojava.bio.program.das.annotation_server";
    public static final String PROPERTY_FEATUREID = "org.biojava.bio.program.das.feature_id";
    public static final String PROPERTY_FEATURELABEL = "org.biojava.bio.program.das.feature_label";
    public static final String PROPERTY_LINKS = "org.biojava.bio.program.das.links";
    public static final String PROPERTY_SEQUENCEVERSION = "org.biojava.bio.program.das.sequence_version";
    public static final int SIZE_THRESHOLD = 500000;
    private DASSequenceDB parentdb;
    private Alphabet alphabet = DNATools.getDNA();
    private URL dataSourceURL;
    private String seqID;
    private String version = null;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    private FeatureRequestManager.Ticket structureTicket;
    private CacheReference refSymbols;
    private int length = -1;
    private Map featureSets = new HashMap();
    private FeatureHolder structure;
    private MergeFeatureHolder features = new MergeFeatureHolder();
    protected transient ChangeSupport changeSupport = null;
    private static DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private static SAXParserFactory spf = SAXParserFactory.newInstance();
    static /* synthetic */ Class class$org$biojava$bio$seq$ComponentFeature;

    DASSequence(DASSequenceDB db, URL dataSourceURL, String seqID, Set dataSources) throws BioException, IllegalIDException {
        this.parentdb = db;
        this.dataSourceURL = dataSourceURL;
        this.seqID = seqID;
        this.structure = new SimpleFeatureHolder();
        SkeletonListener listener = new SkeletonListener();
        FeatureRequestManager frm = this.getParentDB().getFeatureRequestManager();
        this.structureTicket = frm.requestFeatures(dataSourceURL, seqID, listener, null, "component");
        Iterator dsi = dataSources.iterator();
        while (dsi.hasNext()) {
            URL annoURL = (URL)dsi.next();
            DASFeatureSet newFeatureSet = new DASFeatureSet(this, annoURL, seqID);
            this.featureSets.put(annoURL, newFeatureSet);
            this.features.addFeatureHolder(newFeatureSet);
        }
    }

    URL getDataSourceURL() {
        return this.dataSourceURL;
    }

    DASSequenceDB getParentDB() {
        return this.parentdb;
    }

    private FeatureHolder getStructure() throws BioException {
        if (!this.structureTicket.isFetched()) {
            this.structureTicket.doFetch();
        }
        return this.structure;
    }

    private void _addAnnotationSource(URL dataSourceURL) throws BioException, ChangeVetoException {
        FeatureHolder structure = this.getStructure();
        Iterator i = structure.features();
        while (i.hasNext()) {
            DASComponentFeature dcf = (DASComponentFeature)i.next();
            DASSequence seq = dcf.getSequenceLazy();
            if (seq == null) continue;
            seq.addAnnotationSource(dataSourceURL);
        }
        DASFeatureSet fs = new DASFeatureSet(this, dataSourceURL, this.seqID);
        this.featureSets.put(dataSourceURL, fs);
        this.features.addFeatureHolder(fs);
    }

    public Set dataSourceURLs() {
        return Collections.unmodifiableSet(this.featureSets.keySet());
    }

    public void addAnnotationSource(URL dataSourceURL) throws BioException, ChangeVetoException {
        if (!this.featureSets.containsKey(dataSourceURL)) {
            if (this.changeSupport == null) {
                this._addAnnotationSource(dataSourceURL);
            } else {
                ChangeSupport changeSupport = this.changeSupport;
                synchronized (changeSupport) {
                    ChangeEvent ce = new ChangeEvent(this, ANNOTATIONS, null, null);
                    this.changeSupport.firePreChangeEvent(ce);
                    this._addAnnotationSource(dataSourceURL);
                    this.changeSupport.firePostChangeEvent(ce);
                }
            }
        }
    }

    private void _removeAnnotationSource(URL dataSourceURL) throws ChangeVetoException, BioException {
        FeatureHolder structure = this.getStructure();
        FeatureHolder fh = (FeatureHolder)this.featureSets.get(dataSourceURL);
        if (fh != null) {
            Iterator i = structure.features();
            while (i.hasNext()) {
                DASComponentFeature dcf = (DASComponentFeature)i.next();
                DASSequence seq = dcf.getSequenceLazy();
                if (seq == null) continue;
                seq.removeAnnotationSource(dataSourceURL);
            }
            this.features.removeFeatureHolder(fh);
            this.featureSets.remove(dataSourceURL);
        }
    }

    public void removeAnnotationSource(URL dataSourceURL) throws ChangeVetoException, BioException {
        if (this.featureSets.containsKey(dataSourceURL)) {
            if (this.changeSupport == null) {
                this._removeAnnotationSource(dataSourceURL);
            } else {
                ChangeSupport changeSupport = this.changeSupport;
                synchronized (changeSupport) {
                    ChangeEvent ce = new ChangeEvent(this, ANNOTATIONS, null, null);
                    this.changeSupport.firePreChangeEvent(ce);
                    this._removeAnnotationSource(dataSourceURL);
                    this.changeSupport.firePostChangeEvent(ce);
                }
            }
        }
    }

    private int registerLocalFeatureFetchers() {
        Iterator i = this.featureSets.values().iterator();
        while (i.hasNext()) {
            DASFeatureSet dfs = (DASFeatureSet)i.next();
            dfs.registerFeatureFetcher();
        }
        return this.featureSets.size();
    }

    int registerFeatureFetchers() throws BioException {
        int num = this.registerLocalFeatureFetchers();
        FeatureHolder structure = this.getStructure();
        if (this.length() < 500000 && structure.countFeatures() > 0) {
            DASSequence cseq;
            ArrayList<DASSequence> sequences = new ArrayList<DASSequence>();
            Iterator fi = structure.features();
            while (fi.hasNext()) {
                ComponentFeature cf = (ComponentFeature)fi.next();
                cseq = (DASSequence)cf.getComponentSequence();
                sequences.add(cseq);
            }
            Iterator si = sequences.iterator();
            while (si.hasNext()) {
                cseq = (DASSequence)si.next();
                num += cseq.registerFeatureFetchers();
            }
        }
        return num;
    }

    int registerFeatureFetchers(Location l) throws BioException {
        int num = this.registerLocalFeatureFetchers();
        FeatureHolder structure = this.getStructure();
        if (structure.countFeatures() > 0) {
            FeatureHolder componentsBelow = structure.filter(new FeatureFilter.OverlapsLocation(l), false);
            HashMap<DASSequence, Location> sequencesToRegions = new HashMap<DASSequence, Location>();
            Iterator fi = componentsBelow.features();
            while (fi.hasNext()) {
                ComponentFeature cf = (ComponentFeature)fi.next();
                DASSequence cseq = (DASSequence)cf.getComponentSequence();
                if (l.contains(cf.getLocation())) {
                    sequencesToRegions.put(cseq, null);
                    continue;
                }
                Location partNeeded = l.intersection(cf.getLocation());
                if (cf.getStrand() == StrandedFeature.POSITIVE) {
                    partNeeded = partNeeded.translate(cf.getComponentLocation().getMin() - cf.getLocation().getMin());
                    sequencesToRegions.put(cseq, partNeeded);
                    continue;
                }
                sequencesToRegions.put(cseq, null);
            }
            Iterator sri = sequencesToRegions.entrySet().iterator();
            while (sri.hasNext()) {
                Map.Entry srme = sri.next();
                DASSequence cseq = (DASSequence)srme.getKey();
                Location partNeeded = (Location)srme.getValue();
                if (partNeeded != null) {
                    num += cseq.registerFeatureFetchers(partNeeded);
                    continue;
                }
                num += cseq.registerFeatureFetchers();
            }
        }
        return num;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public Iterator iterator() {
        try {
            return this.getSymbols().iterator();
        }
        catch (BioException be) {
            throw new BioError(be, "Can't iterate over symbols");
        }
    }

    public int length() {
        try {
            if (this.length < 0 && !this.structureTicket.isFetched()) {
                this.structureTicket.doFetch();
            }
            if (this.length < 0) {
                this.length = this.getSymbols().length();
            }
            return this.length;
        }
        catch (BioException be) {
            throw new BioError(be, "Can't calculate length");
        }
    }

    public String seqString() {
        try {
            return this.getSymbols().seqString();
        }
        catch (BioException be) {
            throw new BioError(be, "Can't create seqString");
        }
    }

    public String subStr(int start, int end) {
        try {
            return this.getSymbols().subStr(start, end);
        }
        catch (BioException be) {
            throw new BioError(be, "Can't create substring");
        }
    }

    public SymbolList subList(int start, int end) {
        try {
            return this.getSymbols().subList(start, end);
        }
        catch (BioException be) {
            throw new BioError(be, "Can't create subList");
        }
    }

    public Symbol symbolAt(int pos) {
        try {
            return this.getSymbols().symbolAt(pos);
        }
        catch (BioException be) {
            throw new BioError(be, "Can't fetch symbol");
        }
    }

    public List toList() {
        try {
            return this.getSymbols().toList();
        }
        catch (BioException be) {
            throw new BioError(be, "Can't create list");
        }
    }

    public void edit(Edit e) throws ChangeVetoException {
        throw new ChangeVetoException("/You/ try implementing read-write DAS");
    }

    protected SymbolList getSymbols() throws BioException {
        SymbolList sl = null;
        if (this.refSymbols != null) {
            sl = (SymbolList)this.refSymbols.get();
        }
        if (sl == null) {
            FeatureHolder structure = this.getStructure();
            if (structure.countFeatures() == 0) {
                sl = this.getTrueSymbols();
            } else {
                Location coverage = Location.empty;
                AssembledSymbolList asl = new AssembledSymbolList();
                asl.setLength(this.length);
                Iterator i = structure.features();
                while (i.hasNext()) {
                    ComponentFeature cf = (ComponentFeature)i.next();
                    Location loc = cf.getLocation();
                    if (LocationTools.overlaps(loc, coverage)) continue;
                    asl.putComponent(loc, cf);
                    coverage = LocationTools.union(coverage, loc);
                }
                sl = asl;
            }
            this.refSymbols = this.parentdb.getSymbolsCache().makeReference(sl);
        }
        return sl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SymbolList getTrueSymbols() {
        Sequence sequence;
        long startGet = new Date().getTime();
        try {
            try {
                Sequence sl;
                DAS.startedActivity(this);
                URL epURL = new URL(this.dataSourceURL, "dna?ref=" + this.seqID);
                HttpURLConnection huc = (HttpURLConnection)epURL.openConnection();
                huc.setRequestProperty("Accept-Encoding", "gzip");
                huc.connect();
                int status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
                if (status == 0) {
                    throw new BioError("Not a DAS server");
                }
                if (status != 200) {
                    throw new BioError("DAS error (status code = " + status + ")");
                }
                SimpleSequenceBuilder sb = new SimpleSequenceBuilder();
                sb.setURI(epURL.toString());
                sb.setName(this.getName());
                SymbolParser sparser = DNATools.getDNA().getParser("token");
                StreamParser ssparser = sparser.parseStream(sb);
                DNAHandler dnaHandler = new DNAHandler(ssparser);
                String contentEncoding = huc.getContentEncoding();
                InputStream inStream = huc.getInputStream();
                if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                    inStream = new GZIPInputStream(inStream);
                }
                InputSource is = new InputSource(inStream);
                XMLReader parser = DASSequence.nonvalidatingSAXParser();
                parser.setContentHandler(new SAX2StAXAdaptor(dnaHandler));
                parser.parse(is);
                sequence = sl = sb.makeSequence();
                Object var17_18 = null;
            }
            catch (SAXException ex) {
                throw new BioError(ex, "Exception parsing DAS XML");
            }
            catch (IOException ex) {
                throw new BioError(ex, "Error connecting to DAS server");
            }
            catch (BioException ex) {
                throw new BioError(ex);
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            DAS.completedActivity(this);
            throw throwable;
        }
        DAS.completedActivity(this);
        return sequence;
    }

    public String getName() {
        return this.seqID;
    }

    public String getURN() {
        try {
            return new URL(this.dataSourceURL, "?ref=" + this.seqID).toString();
        }
        catch (MalformedURLException ex) {
            throw new BioError(ex);
        }
    }

    public Iterator features() {
        try {
            this.registerFeatureFetchers();
            return this.features.features();
        }
        catch (BioException be) {
            throw new BioError(be, "Couldn't create features iterator");
        }
    }

    public boolean containsFeature(Feature f) {
        return this.features.containsFeature(f);
    }

    public FeatureHolder filter(FeatureFilter ff, boolean recurse) {
        try {
            FeatureHolder structure = this.getStructure();
            FeatureFilter.ByClass structureMembershipFilter = new FeatureFilter.ByClass(class$org$biojava$bio$seq$ComponentFeature == null ? (class$org$biojava$bio$seq$ComponentFeature = DASSequence.class$("org.biojava.bio.seq.ComponentFeature")) : class$org$biojava$bio$seq$ComponentFeature);
            if (FilterUtils.areProperSubset(ff, structureMembershipFilter)) {
                if (recurse) {
                    Iterator fi = structure.features();
                    while (fi.hasNext()) {
                        ComponentFeature cf = (ComponentFeature)fi.next();
                        Sequence cseq = cf.getComponentSequence();
                    }
                }
                return structure.filter(ff, recurse);
            }
            if (recurse) {
                Location ffl = this.extractInterestingLocation(ff);
                int numComponents = 1;
                numComponents = ffl != null ? this.registerFeatureFetchers(ffl) : this.registerFeatureFetchers();
                this.getParentDB().ensureFeaturesCacheCapacity(numComponents * 3);
            } else {
                this.registerLocalFeatureFetchers();
            }
            return this.features.filter(ff, recurse);
        }
        catch (BioException be) {
            throw new BioError(be, "Can't filter");
        }
    }

    private Location extractInterestingLocation(FeatureFilter ff) {
        if (ff instanceof FeatureFilter.OverlapsLocation) {
            return ((FeatureFilter.OverlapsLocation)ff).getLocation();
        }
        if (ff instanceof FeatureFilter.ContainedByLocation) {
            return ((FeatureFilter.ContainedByLocation)ff).getLocation();
        }
        if (ff instanceof FeatureFilter.And) {
            FeatureFilter.And ffa = (FeatureFilter.And)ff;
            Location l1 = this.extractInterestingLocation(ffa.getChild1());
            Location l2 = this.extractInterestingLocation(ffa.getChild2());
            if (l1 != null) {
                if (l2 != null) {
                    return l1.intersection(l2);
                }
                return l1;
            }
            if (l2 != null) {
                return l2;
            }
            return null;
        }
        return null;
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template temp) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public void removeFeature(Feature f) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    public Feature realizeFeature(FeatureHolder dest, Feature.Template temp) throws BioException {
        return this.featureRealizer.realizeFeature(this, dest, temp);
    }

    /*
     * WARNING - void declaration
     */
    public Annotation getAnnotation() {
        try {
            void ex;
            SmallAnnotation anno = new SmallAnnotation();
            anno.setProperty(PROPERTY_SEQUENCEVERSION, this.version);
            return ex;
        }
        catch (ChangeVetoException ex) {
            throw new BioError("Expected to be able to modify annotation");
        }
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public void addChangeListener(ChangeListener cl) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl);
        }
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
        this.generateChangeSupport(ct);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(cl, ct);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl);
            }
        }
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(cl, ct);
            }
        }
    }

    static DocumentBuilder nonvalidatingParser() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception ex) {
            throw new BioError(ex);
        }
    }

    static XMLReader nonvalidatingSAXParser() {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            return spf.newSAXParser().getXMLReader();
        }
        catch (Exception ex) {
            throw new BioError(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            spf.setFeature("http://xml.org/sax/features/validation", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException ex) {
            ex.printStackTrace();
        }
        catch (SAXNotSupportedException ex) {
            ex.printStackTrace();
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    private class SymbolsHandler
    extends StAXContentHandlerBase {
        private StreamParser ssparser;

        SymbolsHandler(StreamParser ssparser) {
            this.ssparser = ssparser;
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            try {
                this.ssparser.close();
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException(ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                int parseStart = start;
                int parseEnd = start;
                int blockEnd = start + length;
                block2: while (true) {
                    if (parseStart >= blockEnd) {
                        return;
                    }
                    while (true) {
                        if (parseStart >= blockEnd || !Character.isSpace(ch[parseStart])) {
                            if (parseStart < blockEnd) break;
                            return;
                        }
                        ++parseStart;
                    }
                    parseEnd = parseStart + 1;
                    while (true) {
                        if (parseEnd >= blockEnd || Character.isSpace(ch[parseEnd])) {
                            this.ssparser.characters(ch, parseStart, parseEnd - parseStart);
                            parseStart = parseEnd;
                            continue block2;
                        }
                        ++parseEnd;
                    }
                    break;
                }
            }
            catch (IllegalSymbolException ex) {
                throw new SAXException(ex);
            }
        }
    }

    private class DNAHandler
    extends StAXContentHandlerBase {
        private StreamParser ssparser;

        DNAHandler(StreamParser ssparser) {
            this.ssparser = ssparser;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (localName.equals("DNA")) {
                dm.delegate(new SymbolsHandler(this.ssparser));
            }
        }
    }

    private class SkeletonListener
    extends SeqIOAdapter {
        private SimpleFeatureHolder structureF;

        private SkeletonListener() {
        }

        public void startSequence() {
            this.structureF = new SimpleFeatureHolder();
        }

        public void endSequence() {
            DASSequence.this.structure = this.structureF;
            if (DASSequence.this.structure.countFeatures() > 0) {
                DASSequence.this.features.addFeatureHolder(DASSequence.this.structure);
            }
        }

        public void addSequenceProperty(Object key, Object value) throws ParseException {
            try {
                if (key.equals("sequence.start")) {
                    int start = Integer.parseInt(value.toString());
                    if (start != 1) {
                        throw new ParseException("Server doesn't think sequence starts at 1.  Wierd.");
                    }
                } else if (key.equals("sequence.stop")) {
                    DASSequence.this.length = Integer.parseInt(value.toString());
                } else if (key.equals("sequence.version")) {
                    DASSequence.this.version = value.toString();
                }
            }
            catch (NumberFormatException ex) {
                throw new ParseException(ex, "Expect numbers for segment start and stop");
            }
        }

        public void startFeature(Feature.Template temp) throws ParseException {
            if (temp instanceof ComponentFeature.Template) {
                String id = (String)temp.annotation.getProperty("sequence.id");
                try {
                    ComponentFeature.Template ctemp = (ComponentFeature.Template)temp;
                    DASComponentFeature cf = new DASComponentFeature(DASSequence.this, ctemp);
                    this.structureF.addFeature(cf);
                    DASSequence.this.length = Math.max(DASSequence.this.length, ctemp.location.getMax());
                }
                catch (BioException ex) {
                    throw new ParseException(ex, "Error instantiating DASComponent");
                }
                catch (ChangeVetoException ex) {
                    throw new BioError(ex, "Immutable FeatureHolder when trying to build structure");
                }
            }
        }
    }
}

