/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.FixedSizeCache;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DASSequenceDB
implements SequenceDB {
    private static final int MAX_CAPACITY = 3000;
    private URL dataSourceURL;
    private Map sequences = new HashMap();
    private Cache symbolsCache = new FixedSizeCache(20);
    private FixedSizeCache featuresCache = new FixedSizeCache(50);
    private Set rootIDs;
    private FeatureRequestManager frm;
    private SequenceDBLite allEntryPoints;

    Cache getSymbolsCache() {
        return this.symbolsCache;
    }

    void ensureFeaturesCacheCapacity(int min) throws BioException {
        if (min > 3000) {
            throw new BioException("Capacity of (3000 exceeded by " + min);
        }
        if (this.featuresCache.getLimit() < min) {
            System.err.println("Setting cache limit up to " + min);
            this.featuresCache.setLimit(min);
        }
    }

    Cache getFeaturesCache() {
        return this.featuresCache;
    }

    FeatureRequestManager getFeatureRequestManager() {
        if (this.frm == null) {
            this.frm = new FeatureRequestManager(this);
        }
        return this.frm;
    }

    public DASSequenceDB(URL dataSourceURL) throws BioException {
        this.dataSourceURL = dataSourceURL;
    }

    DASSequence _getSequence(String id) throws BioException, IllegalIDException {
        return this._getSequence(id, Collections.singleton(this.dataSourceURL));
    }

    DASSequence _getSequence(String id, Set annoURLs) throws BioException, IllegalIDException {
        DASSequence seq = (DASSequence)this.sequences.get(id);
        if (seq == null) {
            seq = new DASSequence(this, this.dataSourceURL, id, annoURLs);
            this.sequences.put(id, seq);
        }
        return seq;
    }

    public SequenceDBLite allEntryPointsDB() {
        if (this.allEntryPoints == null) {
            this.allEntryPoints = new AllEntryPoints();
        }
        return this.allEntryPoints;
    }

    public URL getURL() {
        return this.dataSourceURL;
    }

    public String getName() {
        return this.dataSourceURL.toString();
    }

    public Sequence getSequence(String id) throws BioException, IllegalIDException {
        if (!this.ids().contains(id)) {
            throw new IllegalIDException("Database does not contain " + id + " as a top-level sequence");
        }
        return this._getSequence(id);
    }

    public Set ids() {
        if (this.rootIDs == null) {
            try {
                HashSet<String> ids = new HashSet<String>();
                URL epURL = new URL(this.dataSourceURL, "entry_points");
                HttpURLConnection huc = (HttpURLConnection)epURL.openConnection();
                try {
                    huc.connect();
                }
                catch (Exception e) {
                    throw new BioException(e, "Can't connect to " + epURL);
                }
                int status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
                if (status == 0) {
                    throw new BioException("Not a DAS server: " + this.dataSourceURL + " Query: " + epURL);
                }
                if (status != 200) {
                    throw new BioException("DAS error (status code = " + status + ") connecting to " + this.dataSourceURL + " with query " + epURL);
                }
                InputSource is = new InputSource(huc.getInputStream());
                DocumentBuilder parser = DASSequence.nonvalidatingParser();
                Element el = parser.parse(is).getDocumentElement();
                NodeList segl = el.getElementsByTagName("SEGMENT");
                Object segment = null;
                int i = 0;
                while (i < segl.getLength()) {
                    el = (Element)segl.item(i);
                    String id = el.getAttribute("id");
                    ids.add(id);
                    ++i;
                }
                this.rootIDs = Collections.unmodifiableSet(ids);
            }
            catch (SAXException ex) {
                throw new BioError(ex, "Exception parsing DAS XML");
            }
            catch (IOException ex) {
                throw new BioError(ex, "Error connecting to DAS server");
            }
            catch (NumberFormatException ex) {
                throw new BioError(ex);
            }
            catch (BioException ex) {
                throw new BioError(ex);
            }
        }
        return this.rootIDs;
    }

    public void addSequence(Sequence seq) throws ChangeVetoException {
        throw new ChangeVetoException("No way we're adding sequences to DAS");
    }

    public void removeSequence(String id) throws ChangeVetoException {
        throw new ChangeVetoException("No way we're removing sequences from DAS");
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator i;
            {
                this.i = DASSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Sequence nextSequence() throws BioException {
                return DASSequenceDB.this.getSequence((String)this.i.next());
            }
        };
    }

    static int tolerantIntHeader(HttpURLConnection huc, String name) {
        try {
            String header = huc.getHeaderField(name);
            if (header == null) {
                return 0;
            }
            String firstToken = new StringTokenizer(header).nextToken();
            return Integer.parseInt(firstToken);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public void addChangeListener(ChangeListener cl) {
    }

    public void addChangeListener(ChangeListener cl, ChangeType ct) {
    }

    public void removeChangeListener(ChangeListener cl) {
    }

    public void removeChangeListener(ChangeListener cl, ChangeType ct) {
    }

    private class AllEntryPoints
    implements SequenceDBLite {
        private AllEntryPoints() {
        }

        public Sequence getSequence(String id) throws BioException, IllegalIDException {
            return DASSequenceDB.this._getSequence(id);
        }

        public void addSequence(Sequence seq) throws ChangeVetoException {
            throw new ChangeVetoException("No way we're adding sequences to DAS");
        }

        public void removeSequence(String id) throws ChangeVetoException {
            throw new ChangeVetoException("No way we're removing sequences from DAS");
        }

        public String getName() {
            return "All sequences in " + DASSequenceDB.this.dataSourceURL.toString();
        }

        public void addChangeListener(ChangeListener cl) {
        }

        public void addChangeListener(ChangeListener cl, ChangeType ct) {
        }

        public void removeChangeListener(ChangeListener cl) {
        }

        public void removeChangeListener(ChangeListener cl, ChangeType ct) {
        }
    }
}

