/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.ComponentFeatureHandler;
import org.biojava.bio.program.das.DAS;
import org.biojava.bio.program.das.DASCapabilities;
import org.biojava.bio.program.das.DASGFFParser;
import org.biojava.bio.program.das.DASLinkHandler;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.program.das.DASSequenceDB;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.program.xff.ElementRecognizer;
import org.biojava.bio.program.xff.XFFFeatureSetHandler;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.utils.stax.DelegationManager;
import org.biojava.utils.stax.SAX2StAXAdaptor;
import org.biojava.utils.stax.StAXContentHandler;
import org.biojava.utils.stax.StAXContentHandlerBase;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class FeatureFetcher {
    private HashMap ticketsByID;
    private List doneTickets = Collections.EMPTY_LIST;
    private boolean useXMLFetch = false;
    private String category;
    private String type;
    private URL dataSource;

    FeatureFetcher(URL dataSource, String type, String category) {
        this.ticketsByID = new HashMap();
        this.dataSource = dataSource;
        this.type = type;
        this.category = category;
    }

    URL getDataSourceURL() {
        return this.dataSource;
    }

    void addTicket(FeatureRequestManager.Ticket ticket) {
        this.ticketsByID.put(ticket.getID(), ticket);
    }

    int size() {
        return this.ticketsByID.size();
    }

    List getDoneTickets() {
        return this.doneTickets;
    }

    void setUseXMLFetch(boolean b) {
        this.useXMLFetch = b;
    }

    void runFetch() throws BioException, ParseException {
        long startFetch = new Date().getTime();
        DAS.startedActivity(this);
        URL fURL = null;
        try {
            block20: {
                try {
                    String fetchEncoding = "dasgff";
                    if (DASCapabilities.checkCapable(new URL(this.dataSource, "../"), "featureTable", "xff")) {
                        fetchEncoding = "xff";
                    }
                    HttpURLConnection huc = null;
                    if (this.useXMLFetch) {
                        fURL = new URL(this.dataSource, "features");
                        huc = (HttpURLConnection)fURL.openConnection();
                        huc.setRequestMethod("POST");
                        huc.setRequestProperty("Content-Type", "text/xml");
                        huc.setRequestProperty("Accept-Encoding", "gzip");
                        huc.setDoOutput(true);
                        OutputStream os = huc.getOutputStream();
                        PrintStream ps = new PrintStream(os);
                        ps.print("<featureRequest encoding=\"" + fetchEncoding + "\"");
                        if (this.type != null) {
                            ps.print(" type=\"" + this.type + "\"");
                        }
                        if (this.category != null) {
                            ps.print(" category=\"" + this.category + "\"");
                        }
                        ps.println(">");
                        Iterator i = this.ticketsByID.keySet().iterator();
                        while (i.hasNext()) {
                            String id = (String)i.next();
                            ps.println("  <segment id=\"" + id + "\" />");
                        }
                        ps.println("</featureRequest>");
                        ps.close();
                    } else {
                        String segments;
                        Set segmentIDs = this.ticketsByID.keySet();
                        if (segmentIDs.size() == 1) {
                            segments = "ref=" + (String)segmentIDs.iterator().next();
                        } else {
                            StringBuffer sb = new StringBuffer();
                            Iterator i = segmentIDs.iterator();
                            while (i.hasNext()) {
                                String id = (String)i.next();
                                sb.append("segment=");
                                sb.append(id);
                                if (!i.hasNext()) continue;
                                sb.append(';');
                            }
                            segments = sb.toString();
                        }
                        String encodingRequest = fetchEncoding.equals("dasgff") ? "" : "encoding=" + fetchEncoding + ";";
                        String typeRequest = "";
                        if (this.type != null) {
                            typeRequest = "type=" + this.type + ";";
                        }
                        String categoryRequest = "";
                        if (this.category != null) {
                            categoryRequest = "category=" + this.category + ";";
                        }
                        fURL = new URL(this.dataSource, "features");
                        huc = (HttpURLConnection)fURL.openConnection();
                        huc.setRequestMethod("POST");
                        huc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        huc.setRequestProperty("Accept-Encoding", "gzip");
                        huc.setDoOutput(true);
                        OutputStream os = huc.getOutputStream();
                        PrintStream ps = new PrintStream(os);
                        ps.print(encodingRequest + categoryRequest + typeRequest + segments);
                        ps.close();
                    }
                    huc.connect();
                    int status = DASSequenceDB.tolerantIntHeader(huc, "X-DAS-Status");
                    if (status == 0) {
                        throw new BioError("Not a DAS server: " + fURL.toString());
                    }
                    if (status != 200) {
                        throw new BioError("DAS error (status code = " + status + ")");
                    }
                    String contentEncoding = huc.getContentEncoding();
                    InputStream inStream = huc.getInputStream();
                    if (contentEncoding != null && contentEncoding.indexOf("gzip") != -1) {
                        inStream = new GZIPInputStream(inStream);
                    }
                    if (fetchEncoding.equals("dasgff")) {
                        DASGFFParser gffParser = new DASGFFParser(this.ticketsByID);
                        gffParser.parseStream(inStream);
                        this.doneTickets = gffParser.getDoneTickets();
                        break block20;
                    }
                    if (!fetchEncoding.equals("xff")) break block20;
                    InputSource is = new InputSource(inStream);
                    DASFeaturesHandler dfh = new DASFeaturesHandler(this.ticketsByID, this);
                    XMLReader parser = DASSequence.nonvalidatingSAXParser();
                    parser.setContentHandler(new SAX2StAXAdaptor(dfh));
                    parser.parse(is);
                    this.doneTickets = dfh.getDoneTickets();
                }
                catch (IOException ex) {
                    throw new ParseException(ex);
                }
                catch (SAXException ex) {
                    throw new ParseException(ex, "Error parsing XML from " + fURL);
                }
            }
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            DAS.completedActivity(this);
            throw throwable;
        }
        DAS.completedActivity(this);
    }

    private class DASSegmentHandler
    extends StAXContentHandlerBase {
        private SeqIOListener siol;
        private int level = 0;

        public DASSegmentHandler(SeqIOListener siol) {
            this.siol = siol;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            ++this.level;
            if (this.level == 1) {
                try {
                    String segVersion;
                    String segStop;
                    this.siol.startSequence();
                    String segStart = attrs.getValue("start");
                    if (segStart != null) {
                        this.siol.addSequenceProperty("sequence.start", segStart);
                    }
                    if ((segStop = attrs.getValue("stop")) != null) {
                        this.siol.addSequenceProperty("sequence.stop", segStop);
                    }
                    if ((segVersion = attrs.getValue("version")) == null) return;
                    this.siol.addSequenceProperty("sequence.version", segVersion);
                    return;
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            } else {
                if (!localName.equals("featureSet")) throw new SAXException("Expecting an XFF featureSet and got " + localName);
                XFFFeatureSetHandler xffh = new XFFFeatureSetHandler();
                xffh.setFeatureListener(this.siol);
                xffh.addFeatureHandler(new ElementRecognizer.ByLocalName("componentFeature"), ComponentFeatureHandler.COMPONENTFEATURE_HANDLER_FACTORY);
                xffh.addDetailHandler(new ElementRecognizer.ByNSName("http://www.biojava.org/dazzle", "links"), DASLinkHandler.LINKDETAIL_HANDLER_FACTORY);
                dm.delegate(xffh);
            }
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (this.level == 1) {
                try {
                    this.siol.endSequence();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
            }
            --this.level;
        }
    }

    private class DASFeaturesHandler
    extends StAXContentHandlerBase {
        private boolean inDocument = false;
        private Map ticketsById;
        private FeatureRequestManager.Ticket thisTicket;
        private List doneTickets = new ArrayList();
        private Object trigger;

        public List getDoneTickets() {
            return this.doneTickets;
        }

        public DASFeaturesHandler(Map ticketsById, Object trigger) {
            this.ticketsById = ticketsById;
            this.trigger = trigger;
        }

        public void startElement(String nsURI, String localName, String qName, Attributes attrs, DelegationManager dm) throws SAXException {
            if (!this.inDocument) {
                this.inDocument = true;
            } else if (localName.equals("SEGMENT")) {
                String segID = attrs.getValue("id");
                if (segID == null) {
                    throw new SAXException("Missing segment ID");
                }
                this.thisTicket = (FeatureRequestManager.Ticket)this.ticketsById.get(segID);
                if (this.thisTicket == null) {
                    throw new SAXException("Response segment " + segID + " wasn't requested");
                }
                dm.delegate(new DASSegmentHandler(this.thisTicket.getOutputListener()));
            } else if (localName.equals("segmentNotAnnotated")) {
                String segID = attrs.getValue("id");
                if (segID == null) {
                    throw new SAXException("Missing segment ID");
                }
                FeatureRequestManager.Ticket t = (FeatureRequestManager.Ticket)this.ticketsById.get(segID);
                if (t == null) {
                    throw new SAXException("Response segment " + segID + " wasn't requested");
                }
                SeqIOListener siol = t.getOutputListener();
                try {
                    siol.startSequence();
                    siol.endSequence();
                }
                catch (ParseException ex) {
                    throw new SAXException(ex);
                }
                t.setAsFetched();
                this.doneTickets.add(t);
            } else if (localName.equals("segmentError")) {
                String segID = attrs.getValue("id");
                String segError = attrs.getValue("error");
                throw new SAXException("Error " + segError + " fetching " + segID);
            }
        }

        public void endElement(String nsURI, String localName, String qName, StAXContentHandler handler) throws SAXException {
            if (localName.equals("SEGMENT")) {
                this.thisTicket.setAsFetched();
                this.doneTickets.add(this.thisTicket);
                DAS.activityProgress(this.trigger, this.doneTickets.size(), this.ticketsById.size());
            }
        }
    }
}

