/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.GFFRecordFilter;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceAnnotator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;

public class GFFEntrySet {
    private List lines = new ArrayList();

    public Iterator lineIterator() {
        return this.lines.iterator();
    }

    public void add(String comment) {
        this.lines.add(comment);
    }

    public void add(GFFRecord record) {
        this.lines.add(record);
    }

    public int size() {
        return this.lines.size();
    }

    public SequenceAnnotator getAnnotator() {
        return new SequenceAnnotator(){

            public Sequence annotate(Sequence seq) throws BioException, ChangeVetoException {
                Feature.Template plain = new Feature.Template();
                StrandedFeature.Template stranded = new StrandedFeature.Template();
                plain.annotation = Annotation.EMPTY_ANNOTATION;
                stranded.annotation = Annotation.EMPTY_ANNOTATION;
                Iterator i = GFFEntrySet.this.lineIterator();
                while (i.hasNext()) {
                    GFFRecord rec;
                    Object o = i.next();
                    if (!(o instanceof GFFRecord) || !(rec = (GFFRecord)o).getSeqName().equals(seq.getName())) continue;
                    if (rec.getStrand() == StrandedFeature.UNKNOWN) {
                        plain.location = new RangeLocation(Math.max(1, rec.getStart()), Math.min(rec.getEnd(), seq.length()));
                        plain.type = rec.getFeature();
                        plain.source = rec.getSource();
                        seq.createFeature(plain);
                        continue;
                    }
                    stranded.location = new RangeLocation(Math.max(1, rec.getStart()), Math.min(rec.getEnd(), seq.length()));
                    stranded.type = rec.getFeature();
                    stranded.source = rec.getSource();
                    stranded.strand = rec.getStrand();
                    seq.createFeature(stranded);
                }
                return seq;
            }
        };
    }

    public GFFEntrySet filter(GFFRecordFilter filter) {
        GFFEntrySet accepted = new GFFEntrySet();
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            GFFRecord record;
            Object o = i.next();
            if (!(o instanceof GFFRecord) || !filter.accept(record = (GFFRecord)o)) continue;
            accepted.add(record);
        }
        return accepted;
    }

    public GFFDocumentHandler getAddHandler() {
        return new EntrySetBuilder();
    }

    private class EntrySetBuilder
    implements GFFDocumentHandler {
        private EntrySetBuilder() {
        }

        public void startDocument(String locator) {
        }

        public void endDocument() {
        }

        public void commentLine(String comment) {
            GFFEntrySet.this.lines.add(comment);
        }

        public void recordLine(GFFRecord record) {
            GFFEntrySet.this.lines.add(record);
        }
    }
}

